/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;

public class PayloadMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter;
    @Nullable
    private final Validator validator;
    private final boolean useDefaultResolution;

    public PayloadMethodArgumentResolver(MessageConverter messageConverter) {
        this(messageConverter, null);
    }

    public PayloadMethodArgumentResolver(MessageConverter messageConverter, @Nullable Validator validator) {
        this(messageConverter, validator, true);
    }

    public PayloadMethodArgumentResolver(MessageConverter messageConverter, @Nullable Validator validator, boolean useDefaultResolution) {
        Assert.notNull((Object)messageConverter, (String)"MessageConverter must not be null");
        this.converter = messageConverter;
        this.validator = validator;
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(Payload.class) || this.useDefaultResolution;
    }

    @Override
    @Nullable
    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        Class<?> payloadClass;
        Class<?> targetClass;
        Payload ann = (Payload)parameter.getParameterAnnotation(Payload.class);
        if (ann != null && StringUtils.hasText((String)ann.expression())) {
            throw new IllegalStateException("@Payload SpEL expressions not supported by this resolver");
        }
        boolean isOptionalTargetClass = parameter.getParameterType() == Optional.class;
        Object payload = message.getPayload();
        if (this.isEmptyPayload(payload)) {
            if ((ann == null || ann.required()) && !isOptionalTargetClass) {
                String paramName = this.getParameterName(parameter);
                BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(payload, paramName);
                bindingResult.addError(new ObjectError(paramName, "Payload value must not be empty"));
                throw new MethodArgumentNotValidException(message, parameter, (BindingResult)bindingResult);
            }
            return isOptionalTargetClass ? Optional.empty() : null;
        }
        if (payload instanceof Optional) {
            Optional optional = (Optional)payload;
            payload = optional.get();
            message = MessageBuilder.createMessage(payload, message.getHeaders());
        }
        if (!ClassUtils.isAssignable(targetClass = this.resolveTargetClass(parameter, message), payloadClass = payload.getClass())) {
            MessageConverter messageConverter = this.converter;
            if (messageConverter instanceof SmartMessageConverter) {
                SmartMessageConverter smartConverter = (SmartMessageConverter)messageConverter;
                payload = smartConverter.fromMessage(message, targetClass, parameter);
            } else {
                payload = this.converter.fromMessage(message, targetClass);
            }
            if (payload == null) {
                throw new MessageConversionException(message, "Cannot convert from [" + payloadClass.getName() + "] to [" + targetClass.getName() + "] for " + message);
            }
        }
        this.validate(message, parameter, payload);
        return isOptionalTargetClass ? Optional.of(payload) : payload;
    }

    private String getParameterName(MethodParameter param) {
        String paramName = param.getParameterName();
        return paramName != null ? paramName : "Arg " + param.getParameterIndex();
    }

    protected boolean isEmptyPayload(@Nullable Object payload) {
        if (payload == null) {
            return true;
        }
        if (payload instanceof byte[]) {
            byte[] bytes = (byte[])payload;
            return bytes.length == 0;
        }
        if (payload instanceof String) {
            String text = (String)payload;
            return !StringUtils.hasText((String)text);
        }
        if (payload instanceof Optional) {
            Optional optional = (Optional)payload;
            return optional.isEmpty();
        }
        return false;
    }

    protected Class<?> resolveTargetClass(MethodParameter parameter, Message<?> message) {
        return parameter.nestedIfOptional().getNestedParameterType();
    }

    protected void validate(Message<?> message, MethodParameter parameter, Object target) {
        if (this.validator == null) {
            return;
        }
        for (Annotation ann : parameter.getParameterAnnotations()) {
            Validator validator;
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                Object[] objectHints = hints;
                objectArray = objectHints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            BeanPropertyBindingResult bindingResult = new BeanPropertyBindingResult(target, this.getParameterName(parameter));
            if (!ObjectUtils.isEmpty((Object[])validationHints) && (validator = this.validator) instanceof SmartValidator) {
                SmartValidator sv = (SmartValidator)validator;
                sv.validate(target, (Errors)bindingResult, validationHints);
            } else {
                this.validator.validate(target, (Errors)bindingResult);
            }
            if (!bindingResult.hasErrors()) break;
            throw new MethodArgumentNotValidException(message, parameter, (BindingResult)bindingResult);
        }
    }
}

