/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.DefaultTestContextBootstrapper;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.context.web.WebDelegatingSmartContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;

public class WebTestContextBootstrapper
extends DefaultTestContextBootstrapper {
    @Override
    protected Class<? extends ContextLoader> getDefaultContextLoaderClass(Class<?> testClass) {
        if (AnnotatedElementUtils.hasAnnotation(testClass, WebAppConfiguration.class)) {
            return WebDelegatingSmartContextLoader.class;
        }
        return super.getDefaultContextLoaderClass(testClass);
    }

    @Override
    protected MergedContextConfiguration processMergedContextConfiguration(MergedContextConfiguration mergedConfig) {
        WebAppConfiguration webAppConfiguration = (WebAppConfiguration)AnnotatedElementUtils.findMergedAnnotation(mergedConfig.getTestClass(), WebAppConfiguration.class);
        if (webAppConfiguration != null) {
            return new WebMergedContextConfiguration(mergedConfig, webAppConfiguration.value());
        }
        return mergedConfig;
    }
}

