/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.TestConstructor;

public abstract class TestConstructorUtils {
    private TestConstructorUtils() {
    }

    public static boolean isAutowirableConstructor(Executable executable, Class<?> testClass) {
        return executable instanceof Constructor && TestConstructorUtils.isAutowirableConstructor((Constructor)executable, testClass);
    }

    public static boolean isAutowirableConstructor(Constructor<?> constructor, Class<?> testClass) {
        if (AnnotatedElementUtils.hasAnnotation(constructor, Autowired.class)) {
            return true;
        }
        TestConstructor testConstructor = (TestConstructor)AnnotatedElementUtils.findMergedAnnotation(testClass, TestConstructor.class);
        if (testConstructor != null) {
            return testConstructor.autowire();
        }
        return SpringProperties.getFlag((String)"spring.test.constructor.autowire");
    }
}

