/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.jdbc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.jdbc.datasource.init.ScriptUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.jdbc.SqlConfig;
import org.springframework.util.Assert;

class MergedSqlConfig {
    private static final String COMMENT_PREFIX = "commentPrefix";
    private static final String COMMENT_PREFIXES = "commentPrefixes";
    private final String dataSource;
    private final String transactionManager;
    private final SqlConfig.TransactionMode transactionMode;
    private final String encoding;
    private final String separator;
    private final String[] commentPrefixes;
    private final String blockCommentStartDelimiter;
    private final String blockCommentEndDelimiter;
    private final SqlConfig.ErrorMode errorMode;

    MergedSqlConfig(SqlConfig localSqlConfig, Class<?> testClass) {
        Assert.notNull((Object)localSqlConfig, (String)"Local @SqlConfig must not be null");
        Assert.notNull(testClass, (String)"testClass must not be null");
        AnnotationAttributes mergedAttributes = this.mergeAttributes(localSqlConfig, testClass);
        this.dataSource = mergedAttributes.getString("dataSource");
        this.transactionManager = mergedAttributes.getString("transactionManager");
        this.transactionMode = MergedSqlConfig.getEnum(mergedAttributes, "transactionMode", SqlConfig.TransactionMode.DEFAULT, SqlConfig.TransactionMode.INFERRED);
        this.encoding = mergedAttributes.getString("encoding");
        this.separator = MergedSqlConfig.getString(mergedAttributes, "separator", ";");
        this.commentPrefixes = MergedSqlConfig.getCommentPrefixes(mergedAttributes);
        this.blockCommentStartDelimiter = MergedSqlConfig.getString(mergedAttributes, "blockCommentStartDelimiter", "/*");
        this.blockCommentEndDelimiter = MergedSqlConfig.getString(mergedAttributes, "blockCommentEndDelimiter", "*/");
        this.errorMode = MergedSqlConfig.getEnum(mergedAttributes, "errorMode", SqlConfig.ErrorMode.DEFAULT, SqlConfig.ErrorMode.FAIL_ON_ERROR);
    }

    private AnnotationAttributes mergeAttributes(SqlConfig localSqlConfig, Class<?> testClass) {
        AnnotationAttributes localAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)localSqlConfig, (boolean)false, (boolean)false);
        MergedSqlConfig.enforceCommentPrefixAliases(localAttributes);
        AnnotationAttributes globalAttributes = AnnotatedElementUtils.findMergedAnnotationAttributes(testClass, (String)SqlConfig.class.getName(), (boolean)false, (boolean)false);
        if (globalAttributes == null) {
            return localAttributes;
        }
        MergedSqlConfig.enforceCommentPrefixAliases(globalAttributes);
        for (String key : globalAttributes.keySet()) {
            Object value = localAttributes.get((Object)key);
            if (!MergedSqlConfig.isExplicitValue(value)) continue;
            globalAttributes.put((Object)key, value);
            if (key.equals(COMMENT_PREFIX) && MergedSqlConfig.isEmptyArray(localAttributes.get((Object)COMMENT_PREFIXES))) {
                globalAttributes.put((Object)COMMENT_PREFIXES, value);
                continue;
            }
            if (!key.equals(COMMENT_PREFIXES) || !MergedSqlConfig.isEmptyString(localAttributes.get((Object)COMMENT_PREFIX))) continue;
            globalAttributes.put((Object)COMMENT_PREFIX, value);
        }
        return globalAttributes;
    }

    String getDataSource() {
        return this.dataSource;
    }

    String getTransactionManager() {
        return this.transactionManager;
    }

    SqlConfig.TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    String getEncoding() {
        return this.encoding;
    }

    String getSeparator() {
        return this.separator;
    }

    String[] getCommentPrefixes() {
        return this.commentPrefixes;
    }

    String getBlockCommentStartDelimiter() {
        return this.blockCommentStartDelimiter;
    }

    String getBlockCommentEndDelimiter() {
        return this.blockCommentEndDelimiter;
    }

    SqlConfig.ErrorMode getErrorMode() {
        return this.errorMode;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("dataSource", (Object)this.dataSource).append("transactionManager", (Object)this.transactionManager).append("transactionMode", (Object)this.transactionMode).append("encoding", (Object)this.encoding).append("separator", (Object)this.separator).append(COMMENT_PREFIXES, (Object)this.commentPrefixes).append("blockCommentStartDelimiter", (Object)this.blockCommentStartDelimiter).append("blockCommentEndDelimiter", (Object)this.blockCommentEndDelimiter).append("errorMode", (Object)this.errorMode).toString();
    }

    private static <E extends Enum<?>> E getEnum(AnnotationAttributes attributes, String attributeName, E inheritedOrDefaultValue, E defaultValue) {
        Enum value = attributes.getEnum(attributeName);
        if (value == inheritedOrDefaultValue) {
            value = defaultValue;
        }
        return (E)value;
    }

    private static String getString(AnnotationAttributes attributes, String attributeName, String defaultValue) {
        String value = attributes.getString(attributeName);
        if (value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    private static void enforceCommentPrefixAliases(AnnotationAttributes attributes) {
        String commentPrefix = attributes.getString(COMMENT_PREFIX);
        String[] commentPrefixes = attributes.getStringArray(COMMENT_PREFIXES);
        boolean explicitCommentPrefix = !commentPrefix.isEmpty();
        boolean explicitCommentPrefixes = commentPrefixes.length != 0;
        Assert.isTrue((!explicitCommentPrefix || !explicitCommentPrefixes ? 1 : 0) != 0, (String)"You may declare the 'commentPrefix' or 'commentPrefixes' attribute in @SqlConfig but not both");
        if (explicitCommentPrefix) {
            Assert.hasText((String)commentPrefix, (String)"@SqlConfig(commentPrefix) must contain text");
            attributes.put((Object)COMMENT_PREFIXES, (Object)new String[]{commentPrefix});
        } else if (explicitCommentPrefixes) {
            for (String prefix : commentPrefixes) {
                Assert.hasText((String)prefix, (String)"@SqlConfig(commentPrefixes) must not contain empty prefixes");
            }
            attributes.put((Object)COMMENT_PREFIX, (Object)commentPrefixes);
        } else {
            attributes.put((Object)COMMENT_PREFIX, (Object)commentPrefixes);
        }
    }

    private static String[] getCommentPrefixes(AnnotationAttributes attributes) {
        Object[] commentPrefix = attributes.getStringArray(COMMENT_PREFIX);
        Object[] commentPrefixes = attributes.getStringArray(COMMENT_PREFIXES);
        Assert.state((boolean)Arrays.equals(commentPrefix, commentPrefixes), (String)"Failed to properly handle 'commentPrefix' and 'commentPrefixes' aliases");
        return commentPrefixes.length != 0 ? commentPrefixes : ScriptUtils.DEFAULT_COMMENT_PREFIXES;
    }

    private static boolean isExplicitValue(@Nullable Object value) {
        return !MergedSqlConfig.isEmptyString(value) && !MergedSqlConfig.isEmptyArray(value) && value != SqlConfig.TransactionMode.DEFAULT && value != SqlConfig.ErrorMode.DEFAULT;
    }

    private static boolean isEmptyString(@Nullable Object value) {
        return value instanceof String && ((String)value).isEmpty();
    }

    private static boolean isEmptyArray(@Nullable Object value) {
        return value != null && value.getClass().isArray() && Array.getLength(value) == 0;
    }
}

