/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.hamcrest.Matcher;
import org.springframework.lang.Nullable;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.result.ContentResultMatchers;
import org.springframework.test.web.servlet.result.CookieResultMatchers;
import org.springframework.test.web.servlet.result.FlashAttributeResultMatchers;
import org.springframework.test.web.servlet.result.HandlerResultMatchers;
import org.springframework.test.web.servlet.result.HeaderResultMatchers;
import org.springframework.test.web.servlet.result.JsonPathResultMatchers;
import org.springframework.test.web.servlet.result.ModelResultMatchers;
import org.springframework.test.web.servlet.result.RequestResultMatchers;
import org.springframework.test.web.servlet.result.StatusResultMatchers;
import org.springframework.test.web.servlet.result.ViewResultMatchers;
import org.springframework.test.web.servlet.result.XpathResultMatchers;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class MockMvcResultMatchers {
    private static final AntPathMatcher pathMatcher = new AntPathMatcher();

    public static RequestResultMatchers request() {
        return new RequestResultMatchers();
    }

    public static HandlerResultMatchers handler() {
        return new HandlerResultMatchers();
    }

    public static ModelResultMatchers model() {
        return new ModelResultMatchers();
    }

    public static ViewResultMatchers view() {
        return new ViewResultMatchers();
    }

    public static FlashAttributeResultMatchers flash() {
        return new FlashAttributeResultMatchers();
    }

    public static ResultMatcher forwardedUrl(@Nullable String expectedUrl) {
        return result -> AssertionErrors.assertEquals("Forwarded URL", expectedUrl, result.getResponse().getForwardedUrl());
    }

    public static ResultMatcher forwardedUrlTemplate(String urlTemplate, Object ... uriVars) {
        String uri = UriComponentsBuilder.fromUriString((String)urlTemplate).buildAndExpand(uriVars).encode().toUriString();
        return MockMvcResultMatchers.forwardedUrl(uri);
    }

    public static ResultMatcher forwardedUrlPattern(String urlPattern) {
        return result -> {
            AssertionErrors.assertTrue("'" + urlPattern + "' is not an Ant-style path pattern", pathMatcher.isPattern(urlPattern));
            String url = result.getResponse().getForwardedUrl();
            AssertionErrors.assertTrue("Forwarded URL '" + url + "' does not match the expected URL pattern '" + urlPattern + "'", url != null && pathMatcher.match(urlPattern, url));
        };
    }

    public static ResultMatcher redirectedUrl(String expectedUrl) {
        return result -> AssertionErrors.assertEquals("Redirected URL", expectedUrl, result.getResponse().getRedirectedUrl());
    }

    public static ResultMatcher redirectedUrlTemplate(String urlTemplate, Object ... uriVars) {
        String uri = UriComponentsBuilder.fromUriString((String)urlTemplate).buildAndExpand(uriVars).encode().toUriString();
        return MockMvcResultMatchers.redirectedUrl(uri);
    }

    public static ResultMatcher redirectedUrlPattern(String urlPattern) {
        return result -> {
            AssertionErrors.assertTrue("'" + urlPattern + "' is not an Ant-style path pattern", pathMatcher.isPattern(urlPattern));
            String url = result.getResponse().getRedirectedUrl();
            AssertionErrors.assertTrue("Redirected URL '" + url + "' does not match the expected URL pattern '" + urlPattern + "'", url != null && pathMatcher.match(urlPattern, url));
        };
    }

    public static StatusResultMatchers status() {
        return new StatusResultMatchers();
    }

    public static HeaderResultMatchers header() {
        return new HeaderResultMatchers();
    }

    public static ContentResultMatchers content() {
        return new ContentResultMatchers();
    }

    public static JsonPathResultMatchers jsonPath(String expression, Object ... args) {
        return new JsonPathResultMatchers(expression, args);
    }

    public static <T> ResultMatcher jsonPath(String expression, Matcher<T> matcher) {
        return new JsonPathResultMatchers(expression, new Object[0]).value(matcher);
    }

    public static <T> ResultMatcher jsonPath(String expression, Matcher<T> matcher, Class<T> targetType) {
        return new JsonPathResultMatchers(expression, new Object[0]).value(matcher, targetType);
    }

    public static XpathResultMatchers xpath(String expression, Object ... args) throws XPathExpressionException {
        return new XpathResultMatchers(expression, null, args);
    }

    public static XpathResultMatchers xpath(String expression, Map<String, String> namespaces, Object ... args) throws XPathExpressionException {
        return new XpathResultMatchers(expression, namespaces, args);
    }

    public static CookieResultMatchers cookie() {
        return new CookieResultMatchers();
    }
}

