/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationCollectors;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.RepeatableContainers;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.NestedTestConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.ObjectUtils;

public abstract class MetaAnnotationUtils {
    private static final ConcurrentLruCache<Class<?>, NestedTestConfiguration.EnclosingConfiguration> cachedSearchStrategies = new ConcurrentLruCache(32, MetaAnnotationUtils::lookUpEnclosingConfiguration);

    @Nullable
    public static <T extends Annotation> T findMergedAnnotation(Class<?> clazz, Class<T> annotationType) {
        AnnotationDescriptor<T> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(clazz, annotationType);
        return descriptor != null ? (T)descriptor.synthesizeAnnotation() : null;
    }

    @Nullable
    public static <T extends Annotation> AnnotationDescriptor<T> findAnnotationDescriptor(Class<?> clazz, Class<T> annotationType) {
        return MetaAnnotationUtils.findAnnotationDescriptor(clazz, new HashSet<Annotation>(), annotationType);
    }

    @Nullable
    private static <T extends Annotation> AnnotationDescriptor<T> findAnnotationDescriptor(@Nullable Class<?> clazz, Set<Annotation> visited, Class<T> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        if (clazz == null || Object.class == clazz) {
            return null;
        }
        if (AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) {
            return new AnnotationDescriptor<T>(clazz, clazz.getAnnotation(annotationType));
        }
        for (Annotation composedAnn : clazz.getDeclaredAnnotations()) {
            AnnotationDescriptor<T> descriptor;
            Class<? extends Annotation> composedType = composedAnn.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage((String)composedType.getName()) || !visited.add(composedAnn) || (descriptor = MetaAnnotationUtils.findAnnotationDescriptor(composedType, visited, annotationType)) == null) continue;
            return new AnnotationDescriptor<T>(clazz, descriptor.getDeclaringClass(), composedAnn, descriptor.getAnnotation());
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            AnnotationDescriptor<T> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(ifc, visited, annotationType);
            if (descriptor == null) continue;
            return new AnnotationDescriptor<T>(clazz, descriptor.getDeclaringClass(), descriptor.getComposedAnnotation(), descriptor.getAnnotation());
        }
        AnnotationDescriptor<T> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(clazz.getSuperclass(), visited, annotationType);
        if (descriptor != null) {
            return descriptor;
        }
        if (MetaAnnotationUtils.searchEnclosingClass(clazz) && (descriptor = MetaAnnotationUtils.findAnnotationDescriptor(clazz.getEnclosingClass(), visited, annotationType)) != null) {
            return descriptor;
        }
        return null;
    }

    @Nullable
    public static UntypedAnnotationDescriptor findAnnotationDescriptorForTypes(Class<?> clazz, Class<? extends Annotation> ... annotationTypes) {
        return MetaAnnotationUtils.findAnnotationDescriptorForTypes(clazz, new HashSet<Annotation>(), annotationTypes);
    }

    @Nullable
    private static UntypedAnnotationDescriptor findAnnotationDescriptorForTypes(@Nullable Class<?> clazz, Set<Annotation> visited, Class<? extends Annotation> ... annotationTypes) {
        UntypedAnnotationDescriptor descriptor;
        MetaAnnotationUtils.assertNonEmptyAnnotationTypeArray(annotationTypes, "The list of annotation types must not be empty");
        if (clazz == null || Object.class == clazz) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) continue;
            return new UntypedAnnotationDescriptor(clazz, clazz.getAnnotation(annotationType), annotationTypes);
        }
        for (Annotation composedAnnotation : clazz.getDeclaredAnnotations()) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)composedAnnotation) || !visited.add(composedAnnotation) || (descriptor = MetaAnnotationUtils.findAnnotationDescriptorForTypes(composedAnnotation.annotationType(), visited, annotationTypes)) == null) continue;
            return new UntypedAnnotationDescriptor(clazz, descriptor.getDeclaringClass(), composedAnnotation, (Annotation)descriptor.getAnnotation(), annotationTypes);
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            descriptor = MetaAnnotationUtils.findAnnotationDescriptorForTypes(ifc, visited, annotationTypes);
            if (descriptor == null) continue;
            return new UntypedAnnotationDescriptor(clazz, descriptor.getDeclaringClass(), descriptor.getComposedAnnotation(), (Annotation)descriptor.getAnnotation(), annotationTypes);
        }
        UntypedAnnotationDescriptor descriptor2 = MetaAnnotationUtils.findAnnotationDescriptorForTypes(clazz.getSuperclass(), visited, annotationTypes);
        if (descriptor2 != null) {
            return descriptor2;
        }
        if (MetaAnnotationUtils.searchEnclosingClass(clazz) && (descriptor2 = MetaAnnotationUtils.findAnnotationDescriptorForTypes(clazz.getEnclosingClass(), visited, annotationTypes)) != null) {
            return descriptor2;
        }
        return null;
    }

    public static boolean searchEnclosingClass(Class<?> clazz) {
        return ClassUtils.isInnerClass(clazz) && MetaAnnotationUtils.getEnclosingConfiguration(clazz) == NestedTestConfiguration.EnclosingConfiguration.INHERIT;
    }

    private static NestedTestConfiguration.EnclosingConfiguration getEnclosingConfiguration(Class<?> clazz) {
        return (NestedTestConfiguration.EnclosingConfiguration)((Object)cachedSearchStrategies.get(clazz));
    }

    private static NestedTestConfiguration.EnclosingConfiguration lookUpEnclosingConfiguration(Class<?> clazz) {
        return MergedAnnotations.from(clazz, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY_AND_ENCLOSING_CLASSES).stream(NestedTestConfiguration.class).map(mergedAnnotation -> (NestedTestConfiguration.EnclosingConfiguration)mergedAnnotation.getEnum("value", NestedTestConfiguration.EnclosingConfiguration.class)).findFirst().orElseGet(MetaAnnotationUtils::getDefaultEnclosingConfigurationMode);
    }

    private static NestedTestConfiguration.EnclosingConfiguration getDefaultEnclosingConfigurationMode() {
        String value = SpringProperties.getProperty((String)"spring.test.enclosing.configuration");
        NestedTestConfiguration.EnclosingConfiguration enclosingConfigurationMode = NestedTestConfiguration.EnclosingConfiguration.from(value);
        return enclosingConfigurationMode != null ? enclosingConfigurationMode : NestedTestConfiguration.EnclosingConfiguration.INHERIT;
    }

    private static void assertNonEmptyAnnotationTypeArray(Class<?>[] annotationTypes, String message) {
        if (ObjectUtils.isEmpty((Object[])annotationTypes)) {
            throw new IllegalArgumentException(message);
        }
        for (Class<?> clazz : annotationTypes) {
            if (Annotation.class.isAssignableFrom(clazz)) continue;
            throw new IllegalArgumentException("Array elements must be of type Annotation");
        }
    }

    public static class UntypedAnnotationDescriptor
    extends AnnotationDescriptor<Annotation> {
        @Nullable
        private final Class<? extends Annotation>[] annotationTypes;

        @Deprecated
        public UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Annotation annotation) {
            this(rootDeclaringClass, annotation, null);
        }

        public UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Annotation annotation, @Nullable Class<? extends Annotation>[] annotationTypes) {
            this(rootDeclaringClass, rootDeclaringClass, null, annotation, annotationTypes);
        }

        @Deprecated
        public UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Class<?> declaringClass, @Nullable Annotation composedAnnotation, Annotation annotation) {
            this(rootDeclaringClass, declaringClass, composedAnnotation, annotation, null);
        }

        public UntypedAnnotationDescriptor(Class<?> rootDeclaringClass, Class<?> declaringClass, @Nullable Annotation composedAnnotation, Annotation annotation, @Nullable Class<? extends Annotation>[] annotationTypes) {
            super(rootDeclaringClass, declaringClass, composedAnnotation, annotation);
            this.annotationTypes = annotationTypes;
        }

        @Override
        public Annotation synthesizeAnnotation() {
            throw new UnsupportedOperationException("synthesizeAnnotation() is unsupported in UntypedAnnotationDescriptor");
        }

        @Nullable
        public UntypedAnnotationDescriptor next() {
            if (ObjectUtils.isEmpty((Object[])this.annotationTypes)) {
                throw new UnsupportedOperationException("next() is unsupported if UntypedAnnotationDescriptor is instantiated without 'annotationTypes'");
            }
            UntypedAnnotationDescriptor descriptor = MetaAnnotationUtils.findAnnotationDescriptorForTypes(this.getRootDeclaringClass().getSuperclass(), this.annotationTypes);
            if (descriptor == null && MetaAnnotationUtils.searchEnclosingClass(this.getRootDeclaringClass())) {
                descriptor = MetaAnnotationUtils.findAnnotationDescriptorForTypes(this.getRootDeclaringClass().getEnclosingClass(), this.annotationTypes);
            }
            return descriptor;
        }

        @Override
        public Set<Annotation> findAllLocalMergedAnnotations() {
            throw new UnsupportedOperationException("findAllLocalMergedAnnotations() is unsupported in UntypedAnnotationDescriptor");
        }
    }

    public static class AnnotationDescriptor<T extends Annotation> {
        private final Class<?> rootDeclaringClass;
        private final Class<?> declaringClass;
        @Nullable
        private final Annotation composedAnnotation;
        private final T annotation;
        private final AnnotationAttributes annotationAttributes;

        public AnnotationDescriptor(Class<?> rootDeclaringClass, T annotation) {
            this(rootDeclaringClass, rootDeclaringClass, null, annotation);
        }

        public AnnotationDescriptor(Class<?> rootDeclaringClass, Class<?> declaringClass, @Nullable Annotation composedAnnotation, T annotation) {
            Assert.notNull(rootDeclaringClass, (String)"'rootDeclaringClass' must not be null");
            Assert.notNull(annotation, (String)"Annotation must not be null");
            this.rootDeclaringClass = rootDeclaringClass;
            this.declaringClass = declaringClass;
            this.composedAnnotation = composedAnnotation;
            this.annotation = annotation;
            AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(rootDeclaringClass, (String)annotation.annotationType().getName(), (boolean)false, (boolean)false);
            Assert.state((attributes != null ? 1 : 0) != 0, (String)"No annotation attributes");
            this.annotationAttributes = attributes;
        }

        public Class<?> getRootDeclaringClass() {
            return this.rootDeclaringClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public T synthesizeAnnotation() {
            return (T)AnnotationUtils.synthesizeAnnotation((Map)this.getAnnotationAttributes(), this.getAnnotationType(), this.getRootDeclaringClass());
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.annotation.annotationType();
        }

        public AnnotationAttributes getAnnotationAttributes() {
            return this.annotationAttributes;
        }

        @Nullable
        public Annotation getComposedAnnotation() {
            return this.composedAnnotation;
        }

        @Nullable
        public Class<? extends Annotation> getComposedAnnotationType() {
            return this.composedAnnotation != null ? this.composedAnnotation.annotationType() : null;
        }

        @Nullable
        public AnnotationDescriptor<T> next() {
            Class<Annotation> annotationType = this.getAnnotationType();
            AnnotationDescriptor<Annotation> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(this.getRootDeclaringClass().getSuperclass(), annotationType);
            if (descriptor == null && MetaAnnotationUtils.searchEnclosingClass(this.getRootDeclaringClass())) {
                descriptor = MetaAnnotationUtils.findAnnotationDescriptor(this.getRootDeclaringClass().getEnclosingClass(), annotationType);
            }
            return descriptor;
        }

        public Set<T> findAllLocalMergedAnnotations() {
            MergedAnnotations.SearchStrategy searchStrategy = MetaAnnotationUtils.getEnclosingConfiguration(this.getRootDeclaringClass()) == NestedTestConfiguration.EnclosingConfiguration.INHERIT ? MergedAnnotations.SearchStrategy.TYPE_HIERARCHY_AND_ENCLOSING_CLASSES : MergedAnnotations.SearchStrategy.TYPE_HIERARCHY;
            return (Set)MergedAnnotations.from(this.getRootDeclaringClass(), (MergedAnnotations.SearchStrategy)searchStrategy, (RepeatableContainers)RepeatableContainers.none()).stream(this.getAnnotationType()).filter(MergedAnnotationPredicates.firstRunOf(MergedAnnotation::getAggregateIndex)).collect(MergedAnnotationCollectors.toAnnotationSet());
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("rootDeclaringClass", this.rootDeclaringClass).append("declaringClass", this.declaringClass).append("composedAnnotation", (Object)this.composedAnnotation).append("annotation", this.annotation).toString();
        }
    }
}

