/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.test.web.client.DefaultRequestExpectation;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.RequestExpectation;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.util.Assert;

public abstract class AbstractRequestExpectationManager
implements RequestExpectationManager {
    private final List<RequestExpectation> expectations = new ArrayList<RequestExpectation>();
    private final List<ClientHttpRequest> requests = new ArrayList<ClientHttpRequest>();
    private final Map<ClientHttpRequest, Throwable> requestFailures = new LinkedHashMap<ClientHttpRequest, Throwable>();

    protected List<RequestExpectation> getExpectations() {
        return Collections.unmodifiableList(this.expectations);
    }

    protected List<ClientHttpRequest> getRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    @Override
    public ResponseActions expectRequest(ExpectedCount count, RequestMatcher matcher) {
        Assert.state((boolean)this.requests.isEmpty(), (String)"Cannot add more expectations after actual requests are made");
        DefaultRequestExpectation expectation = new DefaultRequestExpectation(count, matcher);
        this.expectations.add(expectation);
        return expectation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClientHttpResponse validateRequest(ClientHttpRequest request2) throws IOException {
        List<ClientHttpRequest> list = this.requests;
        synchronized (list) {
            RequestExpectation expectation;
            if (this.requests.isEmpty()) {
                this.afterExpectationsDeclared();
            }
            try {
                ClientHttpResponse response = this.validateRequestInternal(request2);
                if (response != null) {
                    ClientHttpResponse clientHttpResponse = response;
                    return clientHttpResponse;
                }
                expectation = this.matchRequest(request2);
            }
            catch (Throwable ex) {
                this.requestFailures.put(request2, ex);
                throw ex;
            }
            finally {
                this.requests.add(request2);
            }
            return expectation.createResponse(request2);
        }
    }

    protected void afterExpectationsDeclared() {
    }

    @Deprecated
    @Nullable
    protected ClientHttpResponse validateRequestInternal(ClientHttpRequest request2) throws IOException {
        return null;
    }

    protected RequestExpectation matchRequest(ClientHttpRequest request2) throws IOException {
        throw new UnsupportedOperationException("It looks like neither the deprecated \"validateRequestInternal\"nor its replacement (this method) are implemented.");
    }

    @Override
    public void verify() {
        int count = this.verifyInternal();
        if (count > 0) {
            String message = "Further request(s) expected leaving " + count + " unsatisfied expectation(s).\n";
            throw new AssertionError((Object)(message + this.getRequestDetails()));
        }
    }

    @Override
    public void verify(Duration timeout) {
        Instant endTime = Instant.now().plus(timeout);
        do {
            if (this.verifyInternal() != 0) continue;
            return;
        } while (Instant.now().isBefore(endTime));
        this.verify();
    }

    private int verifyInternal() {
        if (this.expectations.isEmpty()) {
            return 0;
        }
        if (!this.requestFailures.isEmpty()) {
            throw new AssertionError((Object)("Some requests did not execute successfully.\n" + this.requestFailures.entrySet().stream().map(entry -> "Failed request:\n" + entry.getKey() + "\n" + entry.getValue()).collect(Collectors.joining("\n", "\n", ""))));
        }
        int count = 0;
        for (RequestExpectation expectation : this.expectations) {
            if (expectation.isSatisfied()) continue;
            ++count;
        }
        return count;
    }

    protected String getRequestDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.requests.size()).append(" request(s) executed");
        if (!this.requests.isEmpty()) {
            sb.append(":\n");
            for (ClientHttpRequest request2 : this.requests) {
                sb.append(request2.toString()).append("\n");
            }
        } else {
            sb.append(".\n");
        }
        return sb.toString();
    }

    protected AssertionError createUnexpectedRequestError(ClientHttpRequest request2) {
        HttpMethod method = request2.getMethod();
        URI uri = request2.getURI();
        String message = "No further requests expected: HTTP " + method + " " + uri + "\n";
        return new AssertionError((Object)(message + this.getRequestDetails()));
    }

    @Override
    public void reset() {
        this.expectations.clear();
        this.requests.clear();
        this.requestFailures.clear();
    }

    protected static class RequestExpectationGroup {
        private final Set<RequestExpectation> expectations = new LinkedHashSet<RequestExpectation>();

        protected RequestExpectationGroup() {
        }

        public void addAllExpectations(Collection<RequestExpectation> expectations) {
            this.expectations.addAll(expectations);
        }

        public Set<RequestExpectation> getExpectations() {
            return this.expectations;
        }

        @Nullable
        public RequestExpectation findExpectation(ClientHttpRequest request2) throws IOException {
            for (RequestExpectation expectation : this.expectations) {
                try {
                    expectation.match(request2);
                    return expectation;
                }
                catch (AssertionError assertionError) {
                }
            }
            return null;
        }

        public void update(RequestExpectation expectation) {
            expectation.incrementAndValidate();
            this.updateInternal(expectation);
        }

        private void updateInternal(RequestExpectation expectation) {
            if (expectation.hasRemainingCount()) {
                this.expectations.add(expectation);
            } else {
                this.expectations.remove(expectation);
            }
        }

        @Deprecated
        public void updateAll(Collection<RequestExpectation> expectations) {
            expectations.forEach(this::updateInternal);
        }

        public void reset() {
            this.expectations.clear();
        }
    }
}

