/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

public class PrintingResultHandler
implements ResultHandler {
    private static final String MISSING_CHARACTER_ENCODING = "<no character encoding set>";
    private final ResultValuePrinter printer;

    protected PrintingResultHandler(ResultValuePrinter printer) {
        this.printer = printer;
    }

    protected ResultValuePrinter getPrinter() {
        return this.printer;
    }

    @Override
    public final void handle(MvcResult result) throws Exception {
        this.printer.printHeading("MockHttpServletRequest");
        this.printRequest(result.getRequest());
        this.printer.printHeading("Handler");
        this.printHandler(result.getHandler(), result.getInterceptors());
        this.printer.printHeading("Async");
        this.printAsyncResult(result);
        this.printer.printHeading("Resolved Exception");
        this.printResolvedException(result.getResolvedException());
        this.printer.printHeading("ModelAndView");
        this.printModelAndView(result.getModelAndView());
        this.printer.printHeading("FlashMap");
        this.printFlashMap(RequestContextUtils.getOutputFlashMap((HttpServletRequest)result.getRequest()));
        this.printer.printHeading("MockHttpServletResponse");
        this.printResponse(result.getResponse());
    }

    protected void printRequest(MockHttpServletRequest request2) throws Exception {
        String body2 = request2.getCharacterEncoding() != null ? request2.getContentAsString() : MISSING_CHARACTER_ENCODING;
        this.printer.printValue("HTTP Method", request2.getMethod());
        this.printer.printValue("Request URI", request2.getRequestURI());
        this.printer.printValue("Parameters", this.getParamsMultiValueMap(request2));
        this.printer.printValue("Headers", this.getRequestHeaders(request2));
        this.printer.printValue("Body", body2);
        this.printer.printValue("Session Attrs", this.getSessionAttributes(request2));
    }

    protected final HttpHeaders getRequestHeaders(MockHttpServletRequest request2) {
        HttpHeaders headers = new HttpHeaders();
        Enumeration<String> names = request2.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            headers.put(name, Collections.list(request2.getHeaders(name)));
        }
        return headers;
    }

    protected final MultiValueMap<String, String> getParamsMultiValueMap(MockHttpServletRequest request2) {
        Map<String, String[]> params = request2.getParameterMap();
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        params.forEach((arg_0, arg_1) -> PrintingResultHandler.lambda$getParamsMultiValueMap$0(params, (MultiValueMap)multiValueMap, arg_0, arg_1));
        return multiValueMap;
    }

    protected final Map<String, Object> getSessionAttributes(MockHttpServletRequest request2) {
        Enumeration attrNames;
        HttpSession session = request2.getSession(false);
        if (session != null && (attrNames = session.getAttributeNames()) != null) {
            return Collections.list(attrNames).stream().collect(Collectors.toMap(n -> n, arg_0 -> ((HttpSession)session).getAttribute(arg_0)));
        }
        return Collections.emptyMap();
    }

    protected void printAsyncResult(MvcResult result) throws Exception {
        MockHttpServletRequest request2 = result.getRequest();
        this.printer.printValue("Async started", request2.isAsyncStarted());
        Object asyncResult = null;
        try {
            asyncResult = result.getAsyncResult(0L);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.printer.printValue("Async result", asyncResult);
    }

    protected void printHandler(@Nullable Object handler, @Nullable HandlerInterceptor[] interceptors) throws Exception {
        if (handler == null) {
            this.printer.printValue("Type", null);
        } else if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            this.printer.printValue("Type", handlerMethod.getBeanType().getName());
            this.printer.printValue("Method", handlerMethod);
        } else {
            this.printer.printValue("Type", handler.getClass().getName());
        }
    }

    protected void printResolvedException(@Nullable Exception resolvedException) throws Exception {
        if (resolvedException == null) {
            this.printer.printValue("Type", null);
        } else {
            this.printer.printValue("Type", resolvedException.getClass().getName());
        }
    }

    protected void printModelAndView(@Nullable ModelAndView mav) throws Exception {
        this.printer.printValue("View name", mav != null ? mav.getViewName() : null);
        this.printer.printValue("View", mav != null ? mav.getView() : null);
        if (mav == null || mav.getModel().size() == 0) {
            this.printer.printValue("Model", null);
        } else {
            for (String name : mav.getModel().keySet()) {
                if (name.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
                Object value = mav.getModel().get(name);
                this.printer.printValue("Attribute", name);
                this.printer.printValue("value", value);
                Errors errors = (Errors)mav.getModel().get(BindingResult.MODEL_KEY_PREFIX + name);
                if (errors == null) continue;
                this.printer.printValue("errors", errors.getAllErrors());
            }
        }
    }

    protected void printFlashMap(FlashMap flashMap) throws Exception {
        if (ObjectUtils.isEmpty((Object)flashMap)) {
            this.printer.printValue("Attributes", null);
        } else {
            flashMap.forEach((name, value) -> {
                this.printer.printValue("Attribute", name);
                this.printer.printValue("value", value);
            });
        }
    }

    protected void printResponse(MockHttpServletResponse response) throws Exception {
        this.printer.printValue("Status", response.getStatus());
        this.printer.printValue("Error message", response.getErrorMessage());
        this.printer.printValue("Headers", this.getResponseHeaders(response));
        this.printer.printValue("Content type", response.getContentType());
        this.printer.printValue("Body", response.getContentAsString());
        this.printer.printValue("Forwarded URL", response.getForwardedUrl());
        this.printer.printValue("Redirected URL", response.getRedirectedUrl());
        this.printCookies(response.getCookies());
    }

    private void printCookies(Cookie[] cookies) {
        String[] cookieStrings = new String[cookies.length];
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            cookieStrings[i] = new ToStringCreator((Object)cookie).append("name", (Object)cookie.getName()).append("value", (Object)cookie.getValue()).append("comment", (Object)cookie.getComment()).append("domain", (Object)cookie.getDomain()).append("maxAge", cookie.getMaxAge()).append("path", (Object)cookie.getPath()).append("secure", cookie.getSecure()).append("version", cookie.getVersion()).append("httpOnly", cookie.isHttpOnly()).toString();
        }
        this.printer.printValue("Cookies", cookieStrings);
    }

    protected final HttpHeaders getResponseHeaders(MockHttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : response.getHeaderNames()) {
            headers.put(name, (List)response.getHeaders(name));
        }
        return headers;
    }

    private static /* synthetic */ void lambda$getParamsMultiValueMap$0(Map params, MultiValueMap multiValueMap, String name, String[] values) {
        if (params.get(name) != null) {
            for (String value : values) {
                multiValueMap.add((Object)name, (Object)value);
            }
        }
    }

    protected static interface ResultValuePrinter {
        public void printHeading(String var1);

        public void printValue(String var1, @Nullable Object var2);
    }
}

