/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import jakarta.servlet.DispatcherType;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;

public abstract class MockMvcRequestBuilders {
    public static MockHttpServletRequestBuilder get(String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder get(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.GET, uri);
    }

    public static MockHttpServletRequestBuilder post(String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder post(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.POST, uri);
    }

    public static MockHttpServletRequestBuilder put(String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder put(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PUT, uri);
    }

    public static MockHttpServletRequestBuilder patch(String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder patch(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.PATCH, uri);
    }

    public static MockHttpServletRequestBuilder delete(String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder delete(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.DELETE, uri);
    }

    public static MockHttpServletRequestBuilder options(String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder options(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.OPTIONS, uri);
    }

    public static MockHttpServletRequestBuilder head(String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder head(URI uri) {
        return new MockHttpServletRequestBuilder(HttpMethod.HEAD, uri);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod method, String urlTemplate, Object ... uriVars) {
        return new MockHttpServletRequestBuilder(method, urlTemplate, uriVars);
    }

    public static MockHttpServletRequestBuilder request(HttpMethod httpMethod, URI uri) {
        return new MockHttpServletRequestBuilder(httpMethod, uri);
    }

    public static MockHttpServletRequestBuilder request(String httpMethod, URI uri) {
        return new MockHttpServletRequestBuilder(httpMethod, uri);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(String urlTemplate, Object ... uriVars) {
        return new MockMultipartHttpServletRequestBuilder(urlTemplate, uriVars);
    }

    public static MockMultipartHttpServletRequestBuilder multipart(URI uri) {
        return new MockMultipartHttpServletRequestBuilder(uri);
    }

    public static RequestBuilder asyncDispatch(MvcResult mvcResult) {
        mvcResult.getAsyncResult();
        return servletContext -> {
            MockHttpServletRequest request2 = mvcResult.getRequest();
            request2.setDispatcherType(DispatcherType.ASYNC);
            request2.setAsyncStarted(false);
            return request2;
        };
    }
}

