/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DecoderHttpMessageReader<T>
implements HttpMessageReader<T> {
    private final Decoder<T> decoder;
    private final List<MediaType> readableMediaTypes;

    public DecoderHttpMessageReader(Decoder<T> decoder) {
        this.decoder = decoder;
        this.readableMediaTypes = decoder != null ? MediaType.asMediaTypes(decoder.getDecodableMimeTypes()) : Collections.emptyList();
    }

    @Override
    public boolean canRead(ResolvableType elementType, MediaType mediaType) {
        return this.decoder != null && this.decoder.canDecode(elementType, (MimeType)mediaType);
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return this.readableMediaTypes;
    }

    @Override
    public Flux<T> read(ResolvableType elementType, ReactiveHttpInputMessage inputMessage, Map<String, Object> hints) {
        if (this.decoder == null) {
            return Flux.error((Throwable)new IllegalStateException("No decoder set"));
        }
        MediaType contentType = this.getContentType(inputMessage);
        return this.decoder.decode(inputMessage.getBody(), elementType, (MimeType)contentType, hints);
    }

    @Override
    public Mono<T> readMono(ResolvableType elementType, ReactiveHttpInputMessage inputMessage, Map<String, Object> hints) {
        if (this.decoder == null) {
            return Mono.error((Throwable)new IllegalStateException("No decoder set"));
        }
        MediaType contentType = this.getContentType(inputMessage);
        return this.decoder.decodeToMono(inputMessage.getBody(), elementType, (MimeType)contentType, hints);
    }

    private MediaType getContentType(ReactiveHttpInputMessage inputMessage) {
        MediaType contentType = inputMessage.getHeaders().getContentType();
        return contentType != null ? contentType : MediaType.APPLICATION_OCTET_STREAM;
    }
}

