/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ResourceEncoder;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.codec.AbstractServerHttpMessageWriter;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.ResourceRegionHttpMessageWriter;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResourceHttpMessageWriter
extends AbstractServerHttpMessageWriter<Resource> {
    public static final String HTTP_RANGE_REQUEST_HINT = ResourceHttpMessageWriter.class.getName() + ".httpRange";
    private ResourceRegionHttpMessageWriter resourceRegionHttpMessageWriter;

    public ResourceHttpMessageWriter() {
        super(new EncoderHttpMessageWriter(new ResourceEncoder()));
        this.resourceRegionHttpMessageWriter = new ResourceRegionHttpMessageWriter();
    }

    public ResourceHttpMessageWriter(int bufferSize) {
        super(new EncoderHttpMessageWriter(new ResourceEncoder(bufferSize)));
        this.resourceRegionHttpMessageWriter = new ResourceRegionHttpMessageWriter(bufferSize);
    }

    @Override
    protected Map<String, Object> resolveWriteHints(ResolvableType streamType, ResolvableType elementType, MediaType mediaType, ServerHttpRequest request) {
        List<HttpRange> httpRanges = request.getHeaders().getRange();
        if (!httpRanges.isEmpty()) {
            return Collections.singletonMap(HTTP_RANGE_REQUEST_HINT, httpRanges);
        }
        return Collections.emptyMap();
    }

    @Override
    public Mono<Void> write(Publisher<? extends Resource> inputStream, ResolvableType elementType, MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        return Mono.from((Publisher)Flux.from(inputStream).take(1L).concatMap(resource -> {
            HttpHeaders headers = outputMessage.getHeaders();
            this.addHeaders(headers, (Resource)resource, mediaType);
            return this.writeContent((Resource)resource, elementType, outputMessage, hints);
        }));
    }

    @Override
    public Mono<Void> write(Publisher<? extends Resource> inputStream, ResolvableType streamType, ResolvableType elementType, MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        try {
            response.getHeaders().set("Accept-Ranges", "bytes");
            HashMap<String, Object> mergedHints = new HashMap<String, Object>(hints);
            mergedHints.putAll(this.resolveWriteHints(streamType, elementType, mediaType, request));
            if (mergedHints.containsKey(HTTP_RANGE_REQUEST_HINT)) {
                response.setStatusCode(HttpStatus.PARTIAL_CONTENT);
                List httpRanges = (List)mergedHints.get(HTTP_RANGE_REQUEST_HINT);
                if (httpRanges.size() > 1) {
                    String boundary = MimeTypeUtils.generateMultipartBoundaryString();
                    mergedHints.put(ResourceRegionHttpMessageWriter.BOUNDARY_STRING_HINT, boundary);
                }
                Flux regions = Flux.from(inputStream).flatMap(resource -> Flux.fromIterable(HttpRange.toResourceRegions(httpRanges, resource)));
                return this.resourceRegionHttpMessageWriter.write((Publisher<? extends ResourceRegion>)regions, ResolvableType.forClass(ResourceRegion.class), mediaType, (ReactiveHttpOutputMessage)response, (Map<String, Object>)mergedHints);
            }
            return this.write(inputStream, elementType, mediaType, (ReactiveHttpOutputMessage)response, (Map<String, Object>)mergedHints);
        }
        catch (IllegalArgumentException exc) {
            response.setStatusCode(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
            return response.setComplete();
        }
    }

    protected void addHeaders(HttpHeaders headers, Resource resource, MediaType mediaType) {
        if (headers.getContentType() == null) {
            if (mediaType == null || !mediaType.isConcrete() || MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) {
                mediaType = Optional.ofNullable(MediaTypeFactory.getMediaType(resource)).orElse(MediaType.APPLICATION_OCTET_STREAM);
            }
            headers.setContentType(mediaType);
        }
        if (headers.getContentLength() < 0L) {
            this.contentLength(resource).ifPresent(headers::setContentLength);
        }
    }

    private OptionalLong contentLength(Resource resource) {
        if (InputStreamResource.class != resource.getClass()) {
            try {
                return OptionalLong.of(resource.contentLength());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return OptionalLong.empty();
    }

    private Mono<Void> writeContent(Resource resource, ResolvableType type, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        Optional<File> file;
        if (outputMessage instanceof ZeroCopyHttpOutputMessage && (file = ResourceHttpMessageWriter.getFile(resource)).isPresent()) {
            ZeroCopyHttpOutputMessage zeroCopyResponse = (ZeroCopyHttpOutputMessage)outputMessage;
            return zeroCopyResponse.writeWith(file.get(), 0L, file.get().length());
        }
        return super.write(Mono.just((Object)resource), type, outputMessage.getHeaders().getContentType(), outputMessage, hints);
    }

    private static Optional<File> getFile(Resource resource) {
        if (resource.isFile()) {
            try {
                return Optional.of(resource.getFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

