/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.ResponseContentWriter;
import java.util.Iterator;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;
import rx.functions.Func1;

public class RxNettyServerHttpResponse
extends AbstractServerHttpResponse {
    private final HttpServerResponse<ByteBuf> response;
    private static final ByteBuf FLUSH_SIGNAL = Unpooled.buffer((int)0, (int)0);
    private static final long FLUSH_THRESHOLD = 8192L;

    public RxNettyServerHttpResponse(HttpServerResponse<ByteBuf> response, NettyDataBufferFactory dataBufferFactory) {
        super((DataBufferFactory)dataBufferFactory);
        Assert.notNull(response, (String)"'response' must not be null.");
        this.response = response;
    }

    public HttpServerResponse<?> getRxNettyResponse() {
        return this.response;
    }

    @Override
    protected void applyStatusCode() {
        HttpStatus statusCode = this.getStatusCode();
        if (statusCode != null) {
            this.response.setStatus(HttpResponseStatus.valueOf((int)statusCode.value()));
        }
    }

    @Override
    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> body) {
        Observable content = RxReactiveStreams.toObservable(body).map(NettyDataBufferFactory::toByteBuf);
        return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.response.write(content, (Func1)new FlushSelector(8192L)))).then();
    }

    @Override
    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        Flux bodyWithFlushSignals = Flux.from(body).flatMap(publisher -> Flux.from((Publisher)publisher).map(NettyDataBufferFactory::toByteBuf).concatWith((Publisher)Mono.just((Object)FLUSH_SIGNAL)));
        Observable content = RxReactiveStreams.toObservable((Publisher)bodyWithFlushSignals);
        ResponseContentWriter writer = this.response.write(content, bb -> bb == FLUSH_SIGNAL);
        return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)writer)).then();
    }

    @Override
    protected void applyHeaders() {
        for (String name : this.getHeaders().keySet()) {
            Iterator iterator = this.getHeaders().get(name).iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                this.response.addHeader((CharSequence)name, (Object)value);
            }
        }
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                DefaultCookie cookie = new DefaultCookie(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge(httpCookie.getMaxAge().getSeconds());
                }
                httpCookie.getDomain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
                httpCookie.getPath().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.response.addCookie((Cookie)cookie);
            }
        }
    }

    private class FlushSelector
    implements Func1<ByteBuf, Boolean> {
        private final long flushEvery;
        private long count;

        public FlushSelector(long flushEvery) {
            this.flushEvery = flushEvery;
        }

        public Boolean call(ByteBuf byteBuf) {
            this.count += (long)byteBuf.readableBytes();
            if (this.count >= this.flushEvery) {
                this.count = 0L;
                return true;
            }
            return false;
        }
    }
}

