/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter.reactive;

import java.util.Locale;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class HiddenHttpMethodFilter
implements WebFilter {
    public static final String DEFAULT_METHOD_PARAM = "_method";
    private String methodParam = "_method";

    public void setMethodParam(String methodParam) {
        Assert.hasText((String)methodParam, (String)"'methodParam' must not be empty");
        this.methodParam = methodParam;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (exchange.getRequest().getMethod() == HttpMethod.POST) {
            return exchange.getFormData().map(formData -> {
                String method = (String)formData.getFirst((Object)this.methodParam);
                if (StringUtils.hasLength((String)method)) {
                    return this.convertedRequest(exchange, method);
                }
                return exchange;
            }).then(convertedExchange -> chain.filter((ServerWebExchange)convertedExchange));
        }
        return chain.filter(exchange);
    }

    private ServerWebExchange convertedRequest(ServerWebExchange exchange, String method) {
        HttpMethod resolved = HttpMethod.resolve(method.toUpperCase(Locale.ENGLISH));
        Assert.notNull((Object)((Object)resolved), () -> "HttpMethod '" + method + "' is not supported");
        return exchange.mutate().request(builder -> builder.method(resolved)).build();
    }
}

