/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import org.springframework.web.server.handler.ExceptionHandlingWebHandler;
import org.springframework.web.server.handler.FilteringWebHandler;
import org.springframework.web.server.session.WebSessionManager;

public class WebHttpHandlerBuilder {
    public static final String WEB_HANDLER_BEAN_NAME = "webHandler";
    public static final String WEB_SESSION_MANAGER_BEAN_NAME = "webSessionManager";
    private final WebHandler targetHandler;
    private final List<WebFilter> filters = new ArrayList<WebFilter>();
    private final List<WebExceptionHandler> exceptionHandlers = new ArrayList<WebExceptionHandler>();
    private WebSessionManager sessionManager;

    private WebHttpHandlerBuilder(WebHandler targetHandler) {
        Assert.notNull((Object)targetHandler, (String)"WebHandler must not be null");
        this.targetHandler = targetHandler;
    }

    public static WebHttpHandlerBuilder webHandler(WebHandler webHandler) {
        return new WebHttpHandlerBuilder(webHandler);
    }

    public static WebHttpHandlerBuilder applicationContext(ApplicationContext context) {
        WebHttpHandlerBuilder builder = new WebHttpHandlerBuilder((WebHandler)context.getBean(WEB_HANDLER_BEAN_NAME, WebHandler.class));
        AutowiredFiltersContainer filtersContainer = new AutowiredFiltersContainer();
        context.getAutowireCapableBeanFactory().autowireBean((Object)filtersContainer);
        builder.filters(filtersContainer.getFilters());
        AutowiredExceptionHandlersContainer handlersContainer = new AutowiredExceptionHandlersContainer();
        context.getAutowireCapableBeanFactory().autowireBean((Object)handlersContainer);
        builder.exceptionHandlers(handlersContainer.getExceptionHandlers());
        try {
            builder.sessionManager((WebSessionManager)context.getBean(WEB_SESSION_MANAGER_BEAN_NAME, WebSessionManager.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return builder;
    }

    public WebHttpHandlerBuilder filters(WebFilter ... filters) {
        return this.filters(Arrays.asList(filters));
    }

    public WebHttpHandlerBuilder filters(Collection<? extends WebFilter> filters) {
        if (!ObjectUtils.isEmpty(filters)) {
            this.filters.addAll(filters);
        }
        return this;
    }

    public WebHttpHandlerBuilder exceptionHandlers(WebExceptionHandler ... exceptionHandlers) {
        return this.exceptionHandlers(Arrays.asList(exceptionHandlers));
    }

    public WebHttpHandlerBuilder exceptionHandlers(List<WebExceptionHandler> exceptionHandlers) {
        if (!ObjectUtils.isEmpty(exceptionHandlers)) {
            this.exceptionHandlers.addAll(exceptionHandlers);
        }
        return this;
    }

    public WebHttpHandlerBuilder sessionManager(WebSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public HttpHandler build() {
        Object[] array;
        WebHandler webHandler = this.targetHandler;
        if (!this.filters.isEmpty()) {
            array = new WebFilter[this.filters.size()];
            webHandler = new FilteringWebHandler(webHandler, (WebFilter[])this.filters.toArray(array));
        }
        array = new WebExceptionHandler[this.exceptionHandlers.size()];
        webHandler = new ExceptionHandlingWebHandler(webHandler, (WebExceptionHandler[])this.exceptionHandlers.toArray(array));
        HttpWebHandlerAdapter httpHandler = new HttpWebHandlerAdapter(webHandler);
        if (this.sessionManager != null) {
            httpHandler.setSessionManager(this.sessionManager);
        }
        return httpHandler;
    }

    private static class AutowiredExceptionHandlersContainer {
        private List<WebExceptionHandler> exceptionHandlers;

        private AutowiredExceptionHandlersContainer() {
        }

        @Autowired(required=false)
        public void setExceptionHandlers(List<WebExceptionHandler> exceptionHandlers) {
            this.exceptionHandlers = exceptionHandlers;
        }

        public List<WebExceptionHandler> getExceptionHandlers() {
            return this.exceptionHandlers;
        }
    }

    private static class AutowiredFiltersContainer {
        private List<WebFilter> filters;

        private AutowiredFiltersContainer() {
        }

        @Autowired(required=false)
        public void setFilters(List<WebFilter> filters) {
            this.filters = filters;
        }

        public List<WebFilter> getFilters() {
            return this.filters;
        }
    }
}

