/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import org.springframework.web.util.patterns.PathElement;
import org.springframework.web.util.patterns.PathPattern;

class CaptureTheRestPathElement
extends PathElement {
    private String variableName;
    private char separator;

    CaptureTheRestPathElement(int pos, char[] captureDescriptor, char separator) {
        super(pos);
        this.variableName = new String(captureDescriptor, 2, captureDescriptor.length - 3);
        this.separator = separator;
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        if (candidateIndex < matchingContext.candidateLength && matchingContext.candidate[candidateIndex] != this.separator) {
            return false;
        }
        while (candidateIndex + 1 < matchingContext.candidateLength && matchingContext.candidate[candidateIndex + 1] == this.separator) {
            ++candidateIndex;
        }
        if (matchingContext.extractingVariables) {
            matchingContext.set(this.variableName, new String(matchingContext.candidate, candidateIndex, matchingContext.candidateLength - candidateIndex));
        }
        return true;
    }

    public String toString() {
        return "CaptureTheRest(/{*" + this.variableName + "})";
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }

    @Override
    public int getWildcardCount() {
        return 0;
    }

    @Override
    public int getCaptureCount() {
        return 1;
    }
}

