/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import org.springframework.web.util.patterns.PathElement;
import org.springframework.web.util.patterns.PathPattern;

class LiteralPathElement
extends PathElement {
    private char[] text;
    private int len;
    private boolean caseSensitive;

    public LiteralPathElement(int pos, char[] literalText, boolean caseSensitive) {
        super(pos);
        this.len = literalText.length;
        this.caseSensitive = caseSensitive;
        if (caseSensitive) {
            this.text = literalText;
        } else {
            this.text = new char[literalText.length];
            for (int i = 0; i < this.len; ++i) {
                this.text[i] = Character.toLowerCase(literalText[i]);
            }
        }
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        if (candidateIndex + this.text.length > matchingContext.candidateLength) {
            return false;
        }
        if (this.caseSensitive) {
            for (int i = 0; i < this.len; ++i) {
                if (matchingContext.candidate[candidateIndex++] == this.text[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.len; ++i) {
                if (Character.toLowerCase(matchingContext.candidate[candidateIndex++]) == this.text[i]) continue;
                return false;
            }
        }
        if (this.next == null) {
            return candidateIndex == matchingContext.candidateLength;
        }
        if (matchingContext.isMatchStartMatching && candidateIndex == matchingContext.candidateLength) {
            return true;
        }
        return this.next.matches(candidateIndex, matchingContext);
    }

    @Override
    public int getNormalizedLength() {
        return this.len;
    }

    public String toString() {
        return "Literal(" + new String(this.text) + ")";
    }
}

