/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.web.util.patterns.CaptureTheRestPathElement;
import org.springframework.web.util.patterns.PathElement;
import org.springframework.web.util.patterns.SeparatorPathElement;
import org.springframework.web.util.patterns.WildcardPathElement;
import org.springframework.web.util.patterns.WildcardTheRestPathElement;

public class PathPattern
implements Comparable<PathPattern> {
    private static final Map<String, String> NO_VARIABLES_MAP = Collections.emptyMap();
    private PathElement head;
    private String patternString;
    private char separator;
    private boolean caseSensitive;
    private int capturedVariableCount;
    int normalizedLength;
    boolean endsWithSeparatorWildcard = false;
    private int score;
    private boolean isCatchAll = false;

    public PathPattern(String patternText, PathElement head, char separator, boolean caseSensitive) {
        this.head = head;
        this.patternString = patternText;
        this.separator = separator;
        this.caseSensitive = caseSensitive;
        PathElement s = head;
        while (s != null) {
            this.capturedVariableCount += s.getCaptureCount();
            this.normalizedLength += s.getNormalizedLength();
            this.score += s.getScore();
            if (s instanceof CaptureTheRestPathElement || s instanceof WildcardTheRestPathElement) {
                this.isCatchAll = true;
            }
            if (s instanceof SeparatorPathElement && s.next != null && s.next instanceof WildcardPathElement && s.next.next == null) {
                this.endsWithSeparatorWildcard = true;
            }
            s = s.next;
        }
    }

    public boolean matches(String path) {
        if (this.head == null) {
            return !StringUtils.hasLength((String)path);
        }
        if (!StringUtils.hasLength((String)path)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                path = "";
            } else {
                return false;
            }
        }
        MatchingContext matchingContext = new MatchingContext(path, false);
        return this.head.matches(0, matchingContext);
    }

    public boolean matchStart(String path) {
        if (this.head == null) {
            return !StringUtils.hasLength((String)path);
        }
        if (!StringUtils.hasLength((String)path)) {
            return true;
        }
        MatchingContext matchingContext = new MatchingContext(path, false);
        matchingContext.setMatchStartMatching(true);
        return this.head.matches(0, matchingContext);
    }

    public Map<String, String> matchAndExtract(String path) {
        MatchingContext matchingContext = new MatchingContext(path, true);
        if (this.head != null && this.head.matches(0, matchingContext)) {
            return matchingContext.getExtractedVariables();
        }
        if (!StringUtils.hasLength((String)path)) {
            return NO_VARIABLES_MAP;
        }
        throw new IllegalStateException("Pattern \"" + this.toString() + "\" is not a match for \"" + path + "\"");
    }

    public String getPatternString() {
        return this.patternString;
    }

    public PathElement getHeadSection() {
        return this.head;
    }

    public String extractPathWithinPattern(String path) {
        int end;
        PathElement s = this.head;
        int separatorCount = 0;
        while (s != null) {
            if (s instanceof SeparatorPathElement || s instanceof CaptureTheRestPathElement || s instanceof WildcardTheRestPathElement) {
                ++separatorCount;
            }
            if (s.getWildcardCount() != 0 || s.getCaptureCount() != 0) break;
            s = s.next;
        }
        if (s == null) {
            return "";
        }
        char[] pathChars = path.toCharArray();
        int len = pathChars.length;
        int pos = 0;
        while (separatorCount > 0 && pos < len) {
            if (path.charAt(pos++) != this.separator) continue;
            while (pos < len && path.charAt(pos) == this.separator) {
                ++pos;
            }
            --separatorCount;
        }
        for (end = len; end > 0 && path.charAt(end - 1) == this.separator; --end) {
        }
        StringBuilder stringWithDuplicateSeparatorsRemoved = null;
        for (int c = pos; c < end; ++c) {
            char ch = path.charAt(c);
            if (ch == this.separator && c + 1 < end && path.charAt(c + 1) == this.separator) {
                if (stringWithDuplicateSeparatorsRemoved == null) {
                    stringWithDuplicateSeparatorsRemoved = new StringBuilder();
                    stringWithDuplicateSeparatorsRemoved.append(path.substring(pos, c));
                }
                while (++c + 1 < end && path.charAt(c + 1) == this.separator) {
                }
            }
            if (stringWithDuplicateSeparatorsRemoved == null) continue;
            stringWithDuplicateSeparatorsRemoved.append(ch);
        }
        if (stringWithDuplicateSeparatorsRemoved != null) {
            return stringWithDuplicateSeparatorsRemoved.toString();
        }
        return pos == len ? "" : path.substring(pos, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(PathPattern p) {
        int score;
        if (p == null) {
            return -1;
        }
        if (this.isCatchAll()) {
            if (!p.isCatchAll()) return 1;
            int lenDifference = this.getNormalizedLength() - p.getNormalizedLength();
            if (lenDifference != 0) {
                if (lenDifference >= 0) return -1;
                return 1;
            }
        } else if (p.isCatchAll()) {
            return -1;
        }
        if ((score = this.getScore() - p.getScore()) != 0) {
            if (score >= 0) return 1;
            return -1;
        }
        int lenDifference = this.getNormalizedLength() - p.getNormalizedLength();
        if (lenDifference < 0) {
            return 1;
        }
        if (lenDifference != 0) return -1;
        return 0;
    }

    public int getScore() {
        return this.score;
    }

    public boolean isCatchAll() {
        return this.isCatchAll;
    }

    public int getNormalizedLength() {
        return this.normalizedLength;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathPattern)) {
            return false;
        }
        PathPattern p = (PathPattern)o;
        return this.patternString.equals(p.getPatternString()) && this.separator == p.getSeparator() && this.caseSensitive == p.caseSensitive;
    }

    public int hashCode() {
        return (this.patternString.hashCode() * 17 + this.separator) * 17 + (this.caseSensitive ? 1 : 0);
    }

    public String toChainString() {
        StringBuilder buf = new StringBuilder();
        PathElement pe = this.head;
        while (pe != null) {
            buf.append(pe.toString()).append(" ");
            pe = pe.next;
        }
        return buf.toString().trim();
    }

    public char getSeparator() {
        return this.separator;
    }

    public int getCapturedVariableCount() {
        return this.capturedVariableCount;
    }

    public String toString() {
        return this.patternString;
    }

    public String combine(String pattern2string) {
        boolean secondExtensionWild;
        if (!StringUtils.hasLength((String)this.patternString)) {
            if (!StringUtils.hasLength((String)pattern2string)) {
                return "";
            }
            return pattern2string;
        }
        if (!StringUtils.hasLength((String)pattern2string)) {
            return this.patternString;
        }
        if (!this.patternString.equals(pattern2string) && this.capturedVariableCount == 0 && this.matches(pattern2string)) {
            return pattern2string;
        }
        if (this.endsWithSeparatorWildcard) {
            return this.concat(this.patternString.substring(0, this.patternString.length() - 2), pattern2string);
        }
        int starDotPos1 = this.patternString.indexOf("*.");
        if (this.capturedVariableCount != 0 || starDotPos1 == -1 || this.separator == '.') {
            return this.concat(this.patternString, pattern2string);
        }
        String firstExtension = this.patternString.substring(starDotPos1 + 1);
        int dotPos2 = pattern2string.indexOf(46);
        String file2 = dotPos2 == -1 ? pattern2string : pattern2string.substring(0, dotPos2);
        String secondExtension = dotPos2 == -1 ? "" : pattern2string.substring(dotPos2);
        boolean firstExtensionWild = firstExtension.equals(".*") || firstExtension.equals("");
        boolean bl = secondExtensionWild = secondExtension.equals(".*") || secondExtension.equals("");
        if (!firstExtensionWild && !secondExtensionWild) {
            throw new IllegalArgumentException("Cannot combine patterns: " + this.patternString + " and " + pattern2string);
        }
        return file2 + (firstExtensionWild ? secondExtension : firstExtension);
    }

    private String concat(String path1, String path2) {
        boolean path2StartsWithSeparator;
        boolean path1EndsWithSeparator = path1.charAt(path1.length() - 1) == this.separator;
        boolean bl = path2StartsWithSeparator = path2.charAt(0) == this.separator;
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (path1EndsWithSeparator || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return path1 + this.separator + path2;
    }

    class MatchingContext {
        char[] candidate;
        int candidateLength;
        boolean isMatchStartMatching = false;
        private Map<String, String> extractedVariables;
        public boolean extractingVariables;

        public MatchingContext(String path, boolean extractVariables) {
            this.candidate = path.toCharArray();
            this.candidateLength = this.candidate.length;
            this.extractingVariables = extractVariables;
        }

        public void setMatchStartMatching(boolean b) {
            this.isMatchStartMatching = b;
        }

        public void set(String key, String value) {
            if (this.extractedVariables == null) {
                this.extractedVariables = new HashMap<String, String>();
            }
            this.extractedVariables.put(key, value);
        }

        public Map<String, String> getExtractedVariables() {
            if (this.extractedVariables == null) {
                return NO_VARIABLES_MAP;
            }
            return this.extractedVariables;
        }

        public int scanAhead(int pos) {
            while (pos < this.candidateLength) {
                if (this.candidate[pos] == PathPattern.this.separator) {
                    return pos;
                }
                ++pos;
            }
            return this.candidateLength;
        }
    }
}

