/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import org.springframework.web.util.patterns.PatternMessage;

public class PatternParseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int pos;
    private char[] patternText;
    private final PatternMessage message;
    private final Object[] inserts;

    public PatternParseException(int pos, char[] patternText, PatternMessage message, Object ... inserts) {
        super(message.formatMessage(inserts));
        this.pos = pos;
        this.patternText = patternText;
        this.message = message;
        this.inserts = inserts;
    }

    public PatternParseException(Throwable cause, int pos, char[] patternText, PatternMessage message, Object ... inserts) {
        super(message.formatMessage(inserts), cause);
        this.pos = pos;
        this.patternText = patternText;
        this.message = message;
        this.inserts = inserts;
    }

    @Override
    public String getMessage() {
        return this.message.formatMessage(this.inserts);
    }

    public String toDetailedString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.patternText).append('\n');
        for (int i = 0; i < this.pos; ++i) {
            buf.append(' ');
        }
        buf.append("^\n");
        buf.append(this.getMessage());
        return buf.toString();
    }

    public Object[] getInserts() {
        return this.inserts;
    }

    public int getPosition() {
        return this.pos;
    }

    public PatternMessage getMessageType() {
        return this.message;
    }
}

