/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import org.springframework.web.util.patterns.PathElement;
import org.springframework.web.util.patterns.PathPattern;

class SeparatorPathElement
extends PathElement {
    private char separator;

    SeparatorPathElement(int pos, char separator) {
        super(pos);
        this.separator = separator;
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        boolean matched = false;
        if (candidateIndex < matchingContext.candidateLength && matchingContext.candidate[candidateIndex] == this.separator) {
            while (candidateIndex + 1 < matchingContext.candidateLength && matchingContext.candidate[candidateIndex + 1] == this.separator) {
                ++candidateIndex;
            }
            if (this.next == null) {
                matched = candidateIndex + 1 == matchingContext.candidateLength;
            } else {
                if (matchingContext.isMatchStartMatching && ++candidateIndex == matchingContext.candidateLength) {
                    return true;
                }
                matched = this.next.matches(candidateIndex, matchingContext);
            }
        }
        return matched;
    }

    public String toString() {
        return "Separator(" + this.separator + ")";
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }
}

