/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import org.springframework.web.util.patterns.PathElement;
import org.springframework.web.util.patterns.PathPattern;

class SingleCharWildcardedPathElement
extends PathElement {
    private char[] text;
    private int len;
    private int questionMarkCount;
    private boolean caseSensitive;

    public SingleCharWildcardedPathElement(int pos, char[] literalText, int questionMarkCount, boolean caseSensitive) {
        super(pos);
        this.len = literalText.length;
        this.questionMarkCount = questionMarkCount;
        this.caseSensitive = caseSensitive;
        if (caseSensitive) {
            this.text = literalText;
        } else {
            this.text = new char[literalText.length];
            for (int i = 0; i < this.len; ++i) {
                this.text[i] = Character.toLowerCase(literalText[i]);
            }
        }
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        if (matchingContext.candidateLength < candidateIndex + this.len) {
            return false;
        }
        char[] candidate = matchingContext.candidate;
        if (this.caseSensitive) {
            for (int i = 0; i < this.len; ++i) {
                char t = this.text[i];
                if (t != '?' && candidate[candidateIndex] != t) {
                    return false;
                }
                ++candidateIndex;
            }
        } else {
            for (int i = 0; i < this.len; ++i) {
                char t = this.text[i];
                if (t != '?' && Character.toLowerCase(candidate[candidateIndex]) != t) {
                    return false;
                }
                ++candidateIndex;
            }
        }
        if (this.next == null) {
            return candidateIndex == matchingContext.candidateLength;
        }
        if (matchingContext.isMatchStartMatching && candidateIndex == matchingContext.candidateLength) {
            return true;
        }
        return this.next.matches(candidateIndex, matchingContext);
    }

    @Override
    public int getWildcardCount() {
        return this.questionMarkCount;
    }

    public String toString() {
        return "SingleCharWildcarding(" + new String(this.text) + ")";
    }

    @Override
    public int getNormalizedLength() {
        return this.len;
    }
}

