/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.support.HttpAccessor;
import org.springframework.util.CollectionUtils;

public abstract class InterceptingHttpAccessor
extends HttpAccessor {
    private List<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>();

    public void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        AnnotationAwareOrderComparator.sort(interceptors);
        this.interceptors = interceptors;
    }

    public List<ClientHttpRequestInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public ClientHttpRequestFactory getRequestFactory() {
        ClientHttpRequestFactory delegate = super.getRequestFactory();
        if (!CollectionUtils.isEmpty(this.getInterceptors())) {
            return new InterceptingClientHttpRequestFactory(delegate, this.getInterceptors());
        }
        return delegate;
    }
}

