/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class HttpRequestValues {
    private static final MultiValueMap<String, String> EMPTY_COOKIES_MAP = CollectionUtils.toMultiValueMap(Collections.emptyMap());
    @Nullable
    private final HttpMethod httpMethod;
    @Nullable
    private final URI uri;
    @Nullable
    private final String uriTemplate;
    private final Map<String, String> uriVariables;
    private final HttpHeaders headers;
    private final MultiValueMap<String, String> cookies;
    private final Map<String, Object> attributes;
    @Nullable
    private final Object bodyValue;
    @Nullable
    private final Publisher<?> body;
    @Nullable
    private final ParameterizedTypeReference<?> bodyElementType;

    private HttpRequestValues(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable String uriTemplate, Map<String, String> uriVariables, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes, @Nullable Object bodyValue, @Nullable Publisher<?> body, @Nullable ParameterizedTypeReference<?> bodyElementType) {
        Assert.isTrue((uri != null || uriTemplate != null ? 1 : 0) != 0, (String)"Neither URI nor URI template");
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.uriTemplate = uriTemplate;
        this.uriVariables = uriVariables;
        this.headers = headers;
        this.cookies = cookies;
        this.attributes = attributes;
        this.bodyValue = bodyValue;
        this.body = body;
        this.bodyElementType = bodyElementType;
    }

    @Nullable
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Nullable
    public URI getUri() {
        return this.uri;
    }

    @Nullable
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public Map<String, String> getUriVariables() {
        return this.uriVariables;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public Object getBodyValue() {
        return this.bodyValue;
    }

    @Nullable
    public Publisher<?> getBody() {
        return this.body;
    }

    @Nullable
    public ParameterizedTypeReference<?> getBodyElementType() {
        return this.bodyElementType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private String uriTemplate;
        @Nullable
        private Map<String, String> uriVars;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private MultiValueMap<String, String> requestParams;
        @Nullable
        private MultipartBodyBuilder multipartBuilder;
        @Nullable
        private Map<String, Object> attributes;
        @Nullable
        private Object bodyValue;
        @Nullable
        private Publisher<?> body;
        @Nullable
        private ParameterizedTypeReference<?> bodyElementType;

        public Builder setHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setUriTemplate(String uriTemplate) {
            this.uriTemplate = uriTemplate;
            return this;
        }

        public Builder setUriVariable(String name, String value) {
            this.uriVars = this.uriVars != null ? this.uriVars : new LinkedHashMap<String, String>();
            this.uriVars.put(name, value);
            return this;
        }

        public Builder setAccept(List<MediaType> acceptableMediaTypes) {
            this.initHeaders().setAccept(acceptableMediaTypes);
            return this;
        }

        public Builder setContentType(MediaType contentType) {
            this.initHeaders().setContentType(contentType);
            return this;
        }

        public Builder addHeader(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.initHeaders().add(headerName, headerValue);
            }
            return this;
        }

        private HttpHeaders initHeaders() {
            this.headers = this.headers != null ? this.headers : new HttpHeaders();
            return this.headers;
        }

        public Builder addCookie(String name, String ... values) {
            this.cookies = this.cookies != null ? this.cookies : new LinkedMultiValueMap();
            for (String value : values) {
                this.cookies.add((Object)name, (Object)value);
            }
            return this;
        }

        public Builder addRequestParameter(String name, String ... values) {
            this.requestParams = this.requestParams != null ? this.requestParams : new LinkedMultiValueMap();
            for (String value : values) {
                this.requestParams.add((Object)name, (Object)value);
            }
            return this;
        }

        public Builder addRequestPart(String name, Object part) {
            this.multipartBuilder = this.multipartBuilder != null ? this.multipartBuilder : new MultipartBodyBuilder();
            this.multipartBuilder.part(name, part);
            return this;
        }

        public <T, P extends Publisher<T>> Builder addRequestPart(String name, P publisher, ResolvableType type) {
            this.multipartBuilder = this.multipartBuilder != null ? this.multipartBuilder : new MultipartBodyBuilder();
            this.multipartBuilder.asyncPart(name, publisher, ParameterizedTypeReference.forType((Type)type.getType()));
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            this.attributes = this.attributes != null ? this.attributes : new HashMap<String, Object>();
            this.attributes.put(name, value);
            return this;
        }

        public void setBodyValue(Object bodyValue) {
            this.bodyValue = bodyValue;
            this.body = null;
            this.bodyElementType = null;
        }

        public <T, P extends Publisher<T>> void setBody(P body, ParameterizedTypeReference<T> elementTye) {
            this.body = body;
            this.bodyElementType = elementTye;
            this.bodyValue = null;
        }

        public HttpRequestValues build() {
            URI uri = this.uri;
            String uriTemplate = this.uriTemplate != null ? this.uriTemplate : "";
            HashMap<String, String> uriVars = this.uriVars != null ? new HashMap<String, String>(this.uriVars) : Collections.emptyMap();
            LinkedMultiValueMap bodyValue = this.bodyValue;
            if (!CollectionUtils.isEmpty(this.requestParams)) {
                boolean isFormData;
                boolean bl = isFormData = this.headers != null && MediaType.APPLICATION_FORM_URLENCODED.equals(this.headers.getContentType());
                if (isFormData) {
                    Assert.isTrue((bodyValue == null && this.body == null ? 1 : 0) != 0, (String)"Expected body or request params, not both");
                    bodyValue = new LinkedMultiValueMap(this.requestParams);
                } else if (uri != null) {
                    uri = ((UriComponentsBuilder)UriComponentsBuilder.fromUri(uri).queryParams((MultiValueMap)UriUtils.encodeQueryParams(this.requestParams))).build(true).toUri();
                } else {
                    uriVars = uriVars.isEmpty() ? new HashMap<String, String>() : uriVars;
                    uriTemplate = this.appendQueryParams(uriTemplate, uriVars, this.requestParams);
                }
            } else if (this.multipartBuilder != null) {
                Assert.isTrue((bodyValue == null && this.body == null ? 1 : 0) != 0, (String)"Expected body or request parts, not both");
                bodyValue = this.multipartBuilder.build();
            }
            HttpHeaders headers = HttpHeaders.EMPTY;
            if (this.headers != null) {
                headers = new HttpHeaders();
                headers.putAll((Map<? extends String, ? extends List<String>>)((Object)this.headers));
            }
            LinkedMultiValueMap cookies = this.cookies != null ? new LinkedMultiValueMap(this.cookies) : EMPTY_COOKIES_MAP;
            HashMap<String, Object> attributes = this.attributes != null ? new HashMap<String, Object>(this.attributes) : Collections.emptyMap();
            return new HttpRequestValues(this.httpMethod, uri, uriTemplate, uriVars, headers, (MultiValueMap<String, String>)cookies, attributes, bodyValue, this.body, this.bodyElementType);
        }

        private String appendQueryParams(String uriTemplate, Map<String, String> uriVars, MultiValueMap<String, String> requestParams) {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString(uriTemplate);
            int i = 0;
            for (Map.Entry entry : requestParams.entrySet()) {
                String nameVar = "queryParam" + i;
                uriVars.put(nameVar, (String)entry.getKey());
                for (int j = 0; j < ((List)entry.getValue()).size(); ++j) {
                    String valueVar = nameVar + "[" + j + "]";
                    uriVars.put(valueVar, (String)((List)entry.getValue()).get(j));
                    uriComponentsBuilder.queryParam("{" + nameVar + "}", "{" + valueVar + "}");
                }
                ++i;
            }
            return uriComponentsBuilder.build().toUriString();
        }
    }
}

