/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.Collections;
import java.util.List;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;

public class UnsupportedMediaTypeException
extends NestedRuntimeException {
    @Nullable
    private final MediaType contentType;
    private final List<MediaType> supportedMediaTypes;

    public UnsupportedMediaTypeException(String reason) {
        super(reason);
        this.contentType = null;
        this.supportedMediaTypes = Collections.emptyList();
    }

    public UnsupportedMediaTypeException(@Nullable MediaType contentType2, List<MediaType> supportedMediaTypes) {
        super("Content type '" + (contentType2 != null ? contentType2 : "") + "' not supported");
        this.contentType = contentType2;
        this.supportedMediaTypes = Collections.unmodifiableList(supportedMediaTypes);
    }

    @Nullable
    public MediaType getContentType() {
        return this.contentType;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }
}

