/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.DefaultEntityResponseBuilder;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;

public interface EntityResponse<T>
extends ServerResponse {
    public T entity();

    public BodyInserter<T, ? super ServerHttpResponse> inserter();

    public static <T> Builder<T> fromObject(T t) {
        return new DefaultEntityResponseBuilder<T>(t, BodyInserters.fromObject(t));
    }

    public static <T, P extends Publisher<T>> Builder<P> fromPublisher(P publisher, Class<T> elementClass) {
        return new DefaultEntityResponseBuilder<P>(publisher, BodyInserters.fromPublisher(publisher, elementClass));
    }

    public static <T, P extends Publisher<T>> Builder<P> fromPublisher(P publisher, ParameterizedTypeReference<T> typeReference) {
        return new DefaultEntityResponseBuilder<P>(publisher, BodyInserters.fromPublisher(publisher, typeReference));
    }

    public static interface Builder<T> {
        public Builder<T> header(String var1, String ... var2);

        public Builder<T> headers(HttpHeaders var1);

        public Builder<T> status(HttpStatus var1);

        public Builder<T> status(int var1);

        public Builder<T> cookie(ResponseCookie var1);

        public Builder<T> cookies(Consumer<MultiValueMap<String, ResponseCookie>> var1);

        public Builder<T> allow(HttpMethod ... var1);

        public Builder<T> allow(Set<HttpMethod> var1);

        public Builder<T> eTag(String var1);

        public Builder<T> lastModified(ZonedDateTime var1);

        public Builder<T> lastModified(Instant var1);

        public Builder<T> location(URI var1);

        public Builder<T> cacheControl(CacheControl var1);

        public Builder<T> varyBy(String ... var1);

        public Builder<T> contentLength(long var1);

        public Builder<T> contentType(MediaType var1);

        public Builder<T> hint(String var1, Object var2);

        public Builder<T> hints(Consumer<Map<String, Object>> var1);

        public Mono<EntityResponse<T>> build();
    }
}

