/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.Principal;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.Jetty10WebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class JettyWebSocketClient
implements WebSocketClient,
Lifecycle {
    private static ClassLoader loader = JettyWebSocketClient.class.getClassLoader();
    private static final boolean jetty10Present = ClassUtils.isPresent((String)"org.eclipse.jetty.websocket.client.JettyUpgradeListener", (ClassLoader)loader);
    private static final Log logger = LogFactory.getLog(JettyWebSocketClient.class);
    private final org.eclipse.jetty.websocket.client.WebSocketClient jettyClient;
    private final boolean externallyManaged;
    private final UpgradeHelper upgradeHelper = jetty10Present ? new Jetty10UpgradeHelper() : new Jetty9UpgradeHelper();

    public JettyWebSocketClient() {
        this.jettyClient = new org.eclipse.jetty.websocket.client.WebSocketClient();
        this.externallyManaged = false;
    }

    public JettyWebSocketClient(org.eclipse.jetty.websocket.client.WebSocketClient jettyClient) {
        this.jettyClient = jettyClient;
        this.externallyManaged = true;
    }

    public org.eclipse.jetty.websocket.client.WebSocketClient getJettyClient() {
        return this.jettyClient;
    }

    public void start() {
        if (!this.externallyManaged) {
            try {
                this.jettyClient.start();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to start Jetty WebSocketClient", ex);
            }
        }
    }

    public void stop() {
        if (!this.externallyManaged) {
            try {
                this.jettyClient.stop();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Error stopping Jetty WebSocketClient", ex);
            }
        }
    }

    public boolean isRunning() {
        return this.jettyClient.isRunning();
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        return this.executeInternal(url, headers2, handler);
    }

    private Mono<Void> executeInternal(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        Sinks.Empty completionSink = Sinks.empty();
        return Mono.deferContextual(contextView -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connecting to " + url));
            }
            Object jettyHandler = this.createHandler(url, ContextWebSocketHandler.decorate(handler, contextView), (Sinks.Empty<Void>)completionSink);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setSubProtocols(handler.getSubProtocols());
            return this.upgradeHelper.upgrade(this.jettyClient, jettyHandler, url, request, headers2, (Sinks.Empty<Void>)completionSink);
        });
    }

    private Object createHandler(URI url, WebSocketHandler handler, Sinks.Empty<Void> completion) {
        Function<Session, JettyWebSocketSession> sessionFactory = session -> {
            HandshakeInfo info = this.createHandshakeInfo(url, (Session)session);
            return new JettyWebSocketSession((Session)session, info, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, completion);
        };
        return jetty10Present ? new Jetty10WebSocketHandlerAdapter(handler, sessionFactory) : new JettyWebSocketHandlerAdapter(handler, sessionFactory);
    }

    private HandshakeInfo createHandshakeInfo(URI url, Session jettySession) {
        HttpHeaders headers2 = new HttpHeaders();
        jettySession.getUpgradeResponse().getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)headers2).put(arg_0, arg_1));
        String protocol = headers2.getFirst("Sec-WebSocket-Protocol");
        return new HandshakeInfo(url, headers2, (Mono<Principal>)Mono.empty(), protocol);
    }

    private static class Jetty10UpgradeHelper
    implements UpgradeHelper {
        private static final Method connectMethod;

        private Jetty10UpgradeHelper() {
        }

        @Override
        public Mono<Void> upgrade(org.eclipse.jetty.websocket.client.WebSocketClient jettyClient, Object jettyHandler, URI url, ClientUpgradeRequest request, HttpHeaders headers2, Sinks.Empty<Void> completionSink) {
            ReflectionUtils.invokeMethod((Method)connectMethod, (Object)jettyClient, (Object[])new Object[]{jettyHandler, url, request});
            return completionSink.asMono();
        }

        static {
            try {
                Class<?> type = loader.loadClass("org.eclipse.jetty.websocket.client.WebSocketClient");
                connectMethod = type.getMethod("connect", Object.class, URI.class, ClientUpgradeRequest.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                throw new IllegalStateException("No compatible Jetty version found", ex);
            }
        }
    }

    private static class DefaultUpgradeListener
    implements UpgradeListener {
        private final HttpHeaders headers;

        public DefaultUpgradeListener(HttpHeaders headers2) {
            this.headers = headers2;
        }

        public void onHandshakeRequest(UpgradeRequest request) {
            this.headers.forEach((arg_0, arg_1) -> ((UpgradeRequest)request).setHeader(arg_0, arg_1));
        }

        public void onHandshakeResponse(UpgradeResponse response) {
        }
    }

    private static class Jetty9UpgradeHelper
    implements UpgradeHelper {
        private Jetty9UpgradeHelper() {
        }

        @Override
        public Mono<Void> upgrade(org.eclipse.jetty.websocket.client.WebSocketClient jettyClient, Object jettyHandler, URI url, ClientUpgradeRequest request, HttpHeaders headers2, Sinks.Empty<Void> completionSink) {
            try {
                jettyClient.connect(jettyHandler, url, request, (UpgradeListener)new DefaultUpgradeListener(headers2));
                return completionSink.asMono();
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        }
    }

    private static interface UpgradeHelper {
        public Mono<Void> upgrade(org.eclipse.jetty.websocket.client.WebSocketClient var1, Object var2, URI var3, ClientUpgradeRequest var4, HttpHeaders var5, Sinks.Empty<Void> var6);
    }
}

