/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Supplier;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        HttpServletRequest servletRequest = (HttpServletRequest)ServerHttpRequestDecorator.getNativeRequest((ServerHttpRequest)request);
        HttpServletResponse servletResponse = (HttpServletResponse)ServerHttpResponseDecorator.getNativeResponse((ServerHttpResponse)response);
        ServletContext servletContext = servletRequest.getServletContext();
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory factory = response.bufferFactory();
        return exchange.getResponse().setComplete().then(Mono.deferContextual(contextView -> {
            JettyWebSocketHandlerAdapter adapter = new JettyWebSocketHandlerAdapter(ContextWebSocketHandler.decorate(handler, contextView), session -> new JettyWebSocketSession((Session)session, handshakeInfo, factory));
            JettyWebSocketCreator webSocketCreator = (upgradeRequest, upgradeResponse) -> {
                if (subProtocol != null) {
                    upgradeResponse.setAcceptedSubProtocol(subProtocol);
                }
                return adapter;
            };
            JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer((ServletContext)servletContext);
            try {
                container.upgrade(webSocketCreator, servletRequest, servletResponse);
            }
            catch (Exception ex) {
                return Mono.error((Throwable)ex);
            }
            return Mono.empty();
        }));
    }
}

