/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.ValidationAnnotationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class ModelAttributeMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private final boolean useDefaultResolution;

    public ModelAttributeMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry, boolean useDefaultResolution) {
        super(adapterRegistry);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return this.checkParameterType(parameter, type -> !BeanUtils.isSimpleProperty((Class)type));
        }
        return false;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
        Class resolvedType = type.resolve();
        ReactiveAdapter adapter = resolvedType != null ? this.getAdapterRegistry().getAdapter(resolvedType) : null;
        ResolvableType valueType = adapter != null ? type.getGeneric(new int[0]) : type;
        Assert.state((adapter == null || !adapter.isMultiValue() ? 1 : 0) != 0, () -> this.getClass().getSimpleName() + " does not support multi-value reactive type wrapper: " + parameter.getGenericParameterType());
        String name = ModelInitializer.getNameForParameter(parameter);
        Mono<?> valueMono = this.prepareAttributeMono(name, valueType, context, exchange);
        Sinks.One bindingResultSink = Sinks.unsafe().one();
        Map model = context.getModel().asMap();
        model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResultSink.asMono());
        return valueMono.flatMap(value -> {
            WebExchangeDataBinder binder = context.createDataBinder(exchange, value, name);
            return (this.bindingDisabled(parameter) ? Mono.empty() : this.bindRequestParameters(binder, exchange)).doOnError(arg_0 -> ((Sinks.One)bindingResultSink).tryEmitError(arg_0)).doOnSuccess(aVoid -> {
                this.validateIfApplicable(binder, parameter, exchange);
                BindingResult bindingResult = binder.getBindingResult();
                model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResult);
                model.put(name, value);
                bindingResultSink.tryEmitValue((Object)bindingResult);
            }).then(Mono.fromCallable(() -> {
                BindingResult errors = binder.getBindingResult();
                if (adapter != null) {
                    return adapter.fromPublisher((Publisher)(errors.hasErrors() ? Mono.error((Throwable)new WebExchangeBindException(parameter, errors)) : valueMono));
                }
                if (errors.hasErrors() && !this.hasErrorsArgument(parameter)) {
                    throw new WebExchangeBindException(parameter, errors);
                }
                return value;
            }));
        });
    }

    private boolean bindingDisabled(MethodParameter parameter) {
        ModelAttribute modelAttribute = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        return modelAttribute != null && !modelAttribute.binding();
    }

    protected Mono<Void> bindRequestParameters(WebExchangeDataBinder binder, ServerWebExchange exchange) {
        return binder.bind(exchange);
    }

    private Mono<?> prepareAttributeMono(String attributeName, ResolvableType attributeType, BindingContext context, ServerWebExchange exchange) {
        Object attribute = context.getModel().asMap().get(attributeName);
        if (attribute == null) {
            attribute = this.findAndRemoveReactiveAttribute(context.getModel(), attributeName);
        }
        if (attribute == null) {
            return this.createAttribute(attributeName, attributeType.toClass(), context, exchange);
        }
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(null, attribute);
        if (adapter != null) {
            Assert.isTrue((!adapter.isMultiValue() ? 1 : 0) != 0, (String)"Data binding only supports single-value async types");
            return Mono.from((Publisher)adapter.toPublisher(attribute));
        }
        return Mono.justOrEmpty(attribute);
    }

    @Nullable
    private Object findAndRemoveReactiveAttribute(Model model, String attributeName) {
        return model.asMap().entrySet().stream().filter(entry -> {
            if (!((String)entry.getKey()).startsWith(attributeName)) {
                return false;
            }
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(null, entry.getValue());
            if (adapter == null) {
                return false;
            }
            String name = attributeName + ClassUtils.getShortName((Class)adapter.getReactiveType());
            return ((String)entry.getKey()).equals(name);
        }).findFirst().map(entry -> {
            model.asMap().remove(entry.getKey());
            return entry.getValue();
        }).orElse(null);
    }

    private Mono<?> createAttribute(String attributeName, Class<?> clazz, BindingContext context, ServerWebExchange exchange) {
        Constructor ctor = BeanUtils.getResolvableConstructor(clazz);
        return this.constructAttribute(ctor, attributeName, context, exchange);
    }

    private Mono<?> constructAttribute(Constructor<?> ctor, String attributeName, BindingContext context, ServerWebExchange exchange) {
        if (ctor.getParameterCount() == 0) {
            return Mono.just((Object)BeanUtils.instantiateClass(ctor, (Object[])new Object[0]));
        }
        WebExchangeDataBinder binder = context.createDataBinder(exchange, null, attributeName);
        return this.getValuesToBind(binder, exchange).map(bindValues -> {
            String[] paramNames = BeanUtils.getParameterNames((Constructor)ctor);
            Class<?>[] paramTypes = ctor.getParameterTypes();
            Object[] args = new Object[paramTypes.length];
            String fieldDefaultPrefix = binder.getFieldDefaultPrefix();
            String fieldMarkerPrefix = binder.getFieldMarkerPrefix();
            for (int i2 = 0; i2 < paramNames.length; ++i2) {
                Object object;
                String paramName = paramNames[i2];
                Class<?> paramType = paramTypes[i2];
                Object value = bindValues.get(paramName);
                if (value == null) {
                    if (fieldDefaultPrefix != null) {
                        value = bindValues.get(fieldDefaultPrefix + paramName);
                    }
                    if (value == null && fieldMarkerPrefix != null && bindValues.get(fieldMarkerPrefix + paramName) != null) {
                        value = binder.getEmptyValue(paramType);
                    }
                }
                if (value instanceof List) {
                    List list = (List)value;
                    object = list.toArray();
                } else {
                    object = value;
                }
                value = object;
                MethodParameter methodParam = new MethodParameter(ctor, i2);
                args[i2] = value == null && methodParam.isOptional() ? (methodParam.getParameterType() == Optional.class ? Optional.empty() : null) : binder.convertIfNecessary(value, paramTypes[i2], methodParam);
            }
            return BeanUtils.instantiateClass((Constructor)ctor, (Object[])args);
        });
    }

    public Mono<Map<String, Object>> getValuesToBind(WebExchangeDataBinder binder, ServerWebExchange exchange) {
        return binder.getValuesToBind(exchange);
    }

    private boolean hasErrorsArgument(MethodParameter parameter) {
        int i2 = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        return paramTypes.length > i2 + 1 && Errors.class.isAssignableFrom(paramTypes[i2 + 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateIfApplicable(WebExchangeDataBinder binder, MethodParameter parameter, ServerWebExchange exchange) {
        LocaleContext localeContext = null;
        try {
            for (Annotation ann : parameter.getParameterAnnotations()) {
                Object[] validationHints = ValidationAnnotationUtils.determineValidationHints((Annotation)ann);
                if (validationHints == null) continue;
                if (localeContext == null) {
                    localeContext = exchange.getLocaleContext();
                    LocaleContextHolder.setLocaleContext((LocaleContext)localeContext);
                }
                binder.validate(validationHints);
            }
        }
        finally {
            if (localeContext != null) {
                LocaleContextHolder.resetLocaleContext();
            }
        }
    }
}

