/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRange;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.server.WebSession;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultServerRequest
implements ServerRequest {
    private static final Function<UnsupportedMediaTypeException, UnsupportedMediaTypeStatusException> ERROR_MAPPER = ex -> ex.getContentType() != null ? new UnsupportedMediaTypeStatusException(ex.getContentType(), ex.getSupportedMediaTypes(), ex.getBodyType()) : new UnsupportedMediaTypeStatusException(ex.getMessage(), ex.getSupportedMediaTypes());
    private static final Function<DecodingException, ServerWebInputException> DECODING_MAPPER = ex -> new ServerWebInputException("Failed to read HTTP message", null, (Throwable)ex);
    private final ServerWebExchange exchange;
    private final ServerRequest.Headers headers;
    private final List<HttpMessageReader<?>> messageReaders;

    DefaultServerRequest(ServerWebExchange exchange2, List<HttpMessageReader<?>> messageReaders) {
        this.exchange = exchange2;
        this.messageReaders = List.copyOf(messageReaders);
        this.headers = new DefaultHeaders();
    }

    static Mono<ServerResponse> checkNotModified(ServerWebExchange exchange2, @Nullable Instant lastModified, @Nullable String etag) {
        if (lastModified == null) {
            lastModified = Instant.MIN;
        }
        if (exchange2.checkNotModified(etag, lastModified)) {
            HttpStatusCode statusCode = exchange2.getResponse().getStatusCode();
            return ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)(statusCode != null ? statusCode : HttpStatus.OK)).headers(headers -> headers.addAll((MultiValueMap)exchange2.getResponse().getHeaders()))).build();
        }
        return Mono.empty();
    }

    @Override
    public HttpMethod method() {
        return this.request().getMethod();
    }

    @Override
    @Deprecated
    public String methodName() {
        return this.request().getMethod().name();
    }

    @Override
    public URI uri() {
        return this.request().getURI();
    }

    @Override
    public UriBuilder uriBuilder() {
        return UriComponentsBuilder.fromUri((URI)this.uri());
    }

    @Override
    public RequestPath requestPath() {
        return this.request().getPath();
    }

    @Override
    public ServerRequest.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, HttpCookie> cookies() {
        return this.request().getCookies();
    }

    @Override
    public Optional<InetSocketAddress> remoteAddress() {
        return Optional.ofNullable(this.request().getRemoteAddress());
    }

    @Override
    public Optional<InetSocketAddress> localAddress() {
        return Optional.ofNullable(this.request().getLocalAddress());
    }

    @Override
    public List<HttpMessageReader<?>> messageReaders() {
        return this.messageReaders;
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor) {
        return this.bodyInternal(extractor, Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)this.exchange().getLogPrefix()));
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ServerHttpRequest> extractor, Map<String, Object> hints) {
        hints = Hints.merge(hints, (String)Hints.LOG_PREFIX_HINT, (Object)this.exchange().getLogPrefix());
        return this.bodyInternal(extractor, hints);
    }

    private <T> T bodyInternal(BodyExtractor<T, ? super ServerHttpRequest> extractor, final Map<String, Object> hints) {
        return extractor.extract((ServerHttpRequest)this.request(), new BodyExtractor.Context(){

            @Override
            public List<HttpMessageReader<?>> messageReaders() {
                return DefaultServerRequest.this.messageReaders;
            }

            @Override
            public Optional<ServerHttpResponse> serverResponse() {
                return Optional.of(DefaultServerRequest.this.exchange().getResponse());
            }

            @Override
            public Map<String, Object> hints() {
                return hints;
            }
        });
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        Mono<? extends T> mono = this.body(BodyExtractors.toMono(elementClass));
        return mono.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER).onErrorMap(DecodingException.class, DECODING_MAPPER);
    }

    @Override
    public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> typeReference) {
        Mono<T> mono = this.body(BodyExtractors.toMono(typeReference));
        return mono.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER).onErrorMap(DecodingException.class, DECODING_MAPPER);
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        Flux<? extends T> flux = elementClass.equals(DataBuffer.class) ? this.request().getBody() : this.body(BodyExtractors.toFlux(elementClass));
        return flux.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER).onErrorMap(DecodingException.class, DECODING_MAPPER);
    }

    @Override
    public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> typeReference) {
        Flux<T> flux = this.body(BodyExtractors.toFlux(typeReference));
        return flux.onErrorMap(UnsupportedMediaTypeException.class, ERROR_MAPPER).onErrorMap(DecodingException.class, DECODING_MAPPER);
    }

    @Override
    public <T> Mono<T> bind(Class<T> bindType, Consumer<WebDataBinder> dataBinderCustomizer) {
        Assert.notNull(bindType, (String)"BindType must not be null");
        Assert.notNull(dataBinderCustomizer, (String)"DataBinderCustomizer must not be null");
        return Mono.defer(() -> {
            WebExchangeDataBinder dataBinder = new WebExchangeDataBinder(null);
            dataBinder.setTargetType(ResolvableType.forClass((Class)bindType));
            dataBinderCustomizer.accept((WebDataBinder)dataBinder);
            ServerWebExchange exchange2 = this.exchange();
            return dataBinder.construct(exchange2).then(dataBinder.bind(exchange2)).then(Mono.defer(() -> {
                BindingResult bindingResult = dataBinder.getBindingResult();
                if (bindingResult.hasErrors()) {
                    return Mono.error((Throwable)new BindException(bindingResult));
                }
                Object result = bindingResult.getTarget();
                return Mono.justOrEmpty((Object)result);
            }));
        });
    }

    @Override
    public Map<String, Object> attributes() {
        return this.exchange.getAttributes();
    }

    @Override
    public MultiValueMap<String, String> queryParams() {
        return this.request().getQueryParams();
    }

    @Override
    public Map<String, String> pathVariables() {
        return (Map)this.exchange.getAttributeOrDefault(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap());
    }

    @Override
    public Mono<WebSession> session() {
        return this.exchange.getSession();
    }

    @Override
    public Mono<? extends Principal> principal() {
        return this.exchange.getPrincipal();
    }

    @Override
    public Mono<MultiValueMap<String, String>> formData() {
        return this.exchange.getFormData();
    }

    @Override
    public Mono<MultiValueMap<String, Part>> multipartData() {
        return this.exchange.getMultipartData();
    }

    private ServerHttpRequest request() {
        return this.exchange.getRequest();
    }

    @Override
    public ServerWebExchange exchange() {
        return this.exchange;
    }

    public String toString() {
        return String.format("HTTP %s %s", this.method(), this.path());
    }

    private class DefaultHeaders
    implements ServerRequest.Headers {
        private final HttpHeaders httpHeaders;

        private DefaultHeaders() {
            this.httpHeaders = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)DefaultServerRequest.this.request().getHeaders());
        }

        @Override
        public List<MediaType> accept() {
            return this.httpHeaders.getAccept();
        }

        @Override
        public List<Charset> acceptCharset() {
            return this.httpHeaders.getAcceptCharset();
        }

        @Override
        public List<Locale.LanguageRange> acceptLanguage() {
            return this.httpHeaders.getAcceptLanguage();
        }

        @Override
        public OptionalLong contentLength() {
            long value = this.httpHeaders.getContentLength();
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.httpHeaders.getContentType());
        }

        @Override
        public InetSocketAddress host() {
            return this.httpHeaders.getHost();
        }

        @Override
        public List<HttpRange> range() {
            return this.httpHeaders.getRange();
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.httpHeaders.get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return this.httpHeaders;
        }

        public String toString() {
            return this.httpHeaders.toString();
        }
    }
}

