/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.resource.ResourceHandlerUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

class PathResourceLookupFunction
implements Function<ServerRequest, Mono<Resource>> {
    private final PathPattern pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        ResourceHandlerUtils.assertResourceLocation(location);
        this.pattern = PathPatternParser.defaultInstance.parse(pattern);
        this.location = location;
    }

    @Override
    public Mono<Resource> apply(ServerRequest request) {
        PathContainer pathContainer = request.requestPath().pathWithinApplication();
        if (!this.pattern.matches(pathContainer)) {
            return Mono.empty();
        }
        String path = ResourceHandlerUtils.normalizeInputPath((pathContainer = this.pattern.extractPathWithinPattern(pathContainer)).value());
        if (ResourceHandlerUtils.shouldIgnoreInputPath(path)) {
            return Mono.empty();
        }
        try {
            Resource resource2 = ResourceHandlerUtils.createRelativeResource(this.location, path);
            if (resource2.isReadable() && ResourceHandlerUtils.isResourceUnderLocation(this.location, resource2)) {
                return Mono.just((Object)resource2);
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return String.valueOf(this.pattern) + " -> " + String.valueOf(this.location);
    }
}

