/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.HashMap;
import java.util.List;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlashMap
extends HashMap<String, Object>
implements Comparable<FlashMap> {
    private String targetRequestPath;
    private final MultiValueMap<String, String> targetRequestParams = new LinkedMultiValueMap();
    private long expirationStartTime;
    private int timeToLive;

    public void setTargetRequestPath(String path) {
        this.targetRequestPath = path;
    }

    public String getTargetRequestPath() {
        return this.targetRequestPath;
    }

    public FlashMap addTargetRequestParams(MultiValueMap<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                for (String value : (List)params.get((Object)key)) {
                    this.addTargetRequestParam(key, value);
                }
            }
        }
        return this;
    }

    public FlashMap addTargetRequestParam(String name, String value) {
        if (StringUtils.hasText((String)name) && StringUtils.hasText((String)value)) {
            this.targetRequestParams.add((Object)name, (Object)value);
        }
        return this;
    }

    public MultiValueMap<String, String> getTargetRequestParams() {
        return this.targetRequestParams;
    }

    public void startExpirationPeriod(int timeToLive) {
        this.expirationStartTime = System.currentTimeMillis();
        this.timeToLive = timeToLive;
    }

    public boolean isExpired() {
        if (this.expirationStartTime != 0L) {
            return System.currentTimeMillis() - this.expirationStartTime > (long)(this.timeToLive * 1000);
        }
        return false;
    }

    @Override
    public int compareTo(FlashMap other) {
        int otherUrlPath;
        int thisUrlPath = this.targetRequestPath != null ? 1 : 0;
        int n = otherUrlPath = other.targetRequestPath != null ? 1 : 0;
        if (thisUrlPath != otherUrlPath) {
            return otherUrlPath - thisUrlPath;
        }
        return other.targetRequestParams.size() - this.targetRequestParams.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FlashMap [attributes=").append(super.toString());
        sb.append(", targetRequestPath=").append(this.targetRequestPath);
        sb.append(", targetRequestParams=").append(this.targetRequestParams).append("]");
        return sb.toString();
    }
}

