/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.springframework.http.HttpStatus;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.View;
import org.springframework.web.util.NestedServletException;

public class ServletInvocableHandlerMethod
extends InvocableHandlerMethod {
    private HttpStatus responseStatus;
    private String responseReason;
    private HandlerMethodReturnValueHandlerComposite returnValueHandlers;

    public ServletInvocableHandlerMethod(Object handler, Method method) {
        super(handler, method);
        this.initResponseStatus();
    }

    public ServletInvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
        this.initResponseStatus();
    }

    private void initResponseStatus() {
        ResponseStatus annotation = (ResponseStatus)this.getMethodAnnotation(ResponseStatus.class);
        if (annotation != null) {
            this.responseStatus = annotation.value();
            this.responseReason = annotation.reason();
        }
    }

    public void setHandlerMethodReturnValueHandlers(HandlerMethodReturnValueHandlerComposite returnValueHandlers) {
        this.returnValueHandlers = returnValueHandlers;
    }

    public void invokeAndHandle(ServletWebRequest webRequest, ModelAndViewContainer mavContainer, Object ... providedArgs) throws Exception {
        Object returnValue = this.invokeForRequest((NativeWebRequest)webRequest, mavContainer, providedArgs);
        this.setResponseStatus(webRequest);
        if (returnValue == null) {
            if (this.isRequestNotModified(webRequest) || this.hasResponseStatus() || mavContainer.isRequestHandled()) {
                mavContainer.setRequestHandled(true);
                return;
            }
        } else if (StringUtils.hasText((String)this.responseReason)) {
            mavContainer.setRequestHandled(true);
            return;
        }
        mavContainer.setRequestHandled(false);
        try {
            this.returnValueHandlers.handleReturnValue(returnValue, this.getReturnValueType(returnValue), mavContainer, (NativeWebRequest)webRequest);
        }
        catch (Exception ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.getReturnValueHandlingErrorMessage("Error handling return value", returnValue), (Throwable)ex);
            }
            throw ex;
        }
    }

    private void setResponseStatus(ServletWebRequest webRequest) throws IOException {
        if (this.responseStatus == null) {
            return;
        }
        if (StringUtils.hasText((String)this.responseReason)) {
            webRequest.getResponse().sendError(this.responseStatus.value(), this.responseReason);
        } else {
            webRequest.getResponse().setStatus(this.responseStatus.value());
        }
        webRequest.getRequest().setAttribute(View.RESPONSE_STATUS_ATTRIBUTE, (Object)this.responseStatus);
    }

    private boolean isRequestNotModified(ServletWebRequest webRequest) {
        return webRequest.isNotModified();
    }

    private boolean hasResponseStatus() {
        return this.responseStatus != null;
    }

    private String getReturnValueHandlingErrorMessage(String message, Object returnValue) {
        StringBuilder sb = new StringBuilder(message);
        if (returnValue != null) {
            sb.append(" [type=").append(returnValue.getClass().getName()).append("]");
        }
        sb.append(" [value=").append(returnValue).append("]");
        return this.getDetailedErrorMessage(sb.toString());
    }

    ServletInvocableHandlerMethod wrapConcurrentResult(final Object result) {
        return new CallableHandlerMethod(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (result instanceof Exception) {
                    throw (Exception)result;
                }
                if (result instanceof Throwable) {
                    throw new NestedServletException("Async processing failed", (Throwable)result);
                }
                return result;
            }
        });
    }

    private class CallableHandlerMethod
    extends ServletInvocableHandlerMethod {
        public CallableHandlerMethod(Callable<?> callable) {
            super(callable, ClassUtils.getMethod(callable.getClass(), (String)"call", (Class[])new Class[0]));
            this.setHandlerMethodReturnValueHandlers(ServletInvocableHandlerMethod.this.returnValueHandlers);
        }

        public Class<?> getBeanType() {
            return ServletInvocableHandlerMethod.this.getBeanType();
        }

        public <A extends Annotation> A getMethodAnnotation(Class<A> annotationType) {
            return (A)ServletInvocableHandlerMethod.this.getMethodAnnotation(annotationType);
        }
    }
}

