/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.WebContentGenerator;

public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
InitializingBean {
    private static final Log logger = LogFactory.getLog(ResourceHttpRequestHandler.class);
    private static final boolean jafPresent = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)ResourceHttpRequestHandler.class.getClassLoader());
    private List<Resource> locations;

    public ResourceHttpRequestHandler() {
        super("GET", "HEAD");
    }

    public void setLocations(List<Resource> locations) {
        Assert.notEmpty(locations, (String)"Locations list must not be empty");
        this.locations = locations;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isWarnEnabled() && CollectionUtils.isEmpty(this.locations)) {
            logger.warn((Object)"Locations list is empty. No resources will be served");
        }
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkAndPrepare(request, response, true);
        Resource resource = this.getResource(request);
        if (resource == null) {
            logger.debug((Object)"No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        MediaType mediaType = this.getMediaType(resource);
        if (mediaType != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Determined media type '" + mediaType + "' for " + resource));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No media type found for " + resource + " - not sending a content-type header"));
        }
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            logger.debug((Object)"Resource not modified - returning 304");
            return;
        }
        this.setHeaders(response, resource, mediaType);
        if ("HEAD".equals(request.getMethod())) {
            logger.trace((Object)"HEAD request - skipping content");
            return;
        }
        this.writeContent(response, resource);
    }

    protected Resource getResource(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (!StringUtils.hasText((String)(path = this.processPath(path))) || this.isInvalidPath(path)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring invalid resource path [" + path + "]"));
            }
            return null;
        }
        if (path.contains("%")) {
            try {
                if (this.isInvalidPath(URLDecoder.decode(path, "UTF-8"))) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Ignoring invalid resource path with escape sequences [" + path + "]."));
                    }
                    return null;
                }
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (Resource location : this.locations) {
            try {
                Resource resource;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying relative path [" + path + "] against base location: " + location));
                }
                if ((resource = location.createRelative(path)).exists() && resource.isReadable()) {
                    if (this.isResourceUnderLocation(resource, location)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found matching resource: " + resource));
                        }
                        return resource;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("resource=\"" + resource + "\" was successfully resolved " + "but is not under the location=\"" + location));
                    }
                    return null;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("Relative resource doesn't exist or isn't readable: " + resource));
            }
            catch (IOException ex) {
                logger.debug((Object)"Failed to create relative resource - trying next resource location", (Throwable)ex);
            }
        }
        return null;
    }

    protected String processPath(String path) {
        boolean slash = false;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i) <= ' ' || path.charAt(i) == '\u007f') continue;
            if (i == 0 || i == 1 && slash) {
                return path;
            }
            String string = path = slash ? "/" + path.substring(i) : path.substring(i);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Path trimmed for leading '/' and control characters: " + path));
            }
            return path;
        }
        return slash ? "/" : "";
    }

    protected boolean isInvalidPath(String path) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Applying \"invalid path\" checks to path: " + path));
        }
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"WEB-INF\" or \"META-INF\".");
            }
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Path represents URL or has \"url:\" prefix.");
                }
                return true;
            }
        }
        if (path.contains("../") && (path = StringUtils.cleanPath((String)path)).contains("../")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Path contains \"../\" after call to StringUtils#cleanPath.");
            }
            return true;
        }
        return false;
    }

    private boolean isResourceUnderLocation(Resource resource, Resource location) throws IOException {
        String locationPath;
        String resourcePath;
        if (!resource.getClass().equals(location.getClass())) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = location.getURL().toExternalForm();
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = ((ClassPathResource)location).getPath();
        } else if (resource instanceof ServletContextResource) {
            resourcePath = ((ServletContextResource)resource).getPath();
            locationPath = ((ServletContextResource)location).getPath();
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = location.getURL().getPath();
        }
        String string = locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        if (!resourcePath.startsWith(locationPath)) {
            return false;
        }
        if (resourcePath.contains("%") && URLDecoder.decode(resourcePath, "UTF-8").contains("../")) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Resolved resource path contains \"../\" after decoding: " + resourcePath));
            }
            return false;
        }
        return true;
    }

    protected MediaType getMediaType(Resource resource) {
        MediaType jafMediaType;
        MediaType mediaType = null;
        String mimeType = this.getServletContext().getMimeType(resource.getFilename());
        if (StringUtils.hasText((String)mimeType)) {
            mediaType = MediaType.parseMediaType((String)mimeType);
        }
        if (jafPresent && (mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals((Object)mediaType)) && (jafMediaType = ActivationMediaTypeFactory.getMediaType(resource.getFilename())) != null && !MediaType.APPLICATION_OCTET_STREAM.equals((Object)jafMediaType)) {
            mediaType = jafMediaType;
        }
        return mediaType;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Resource content too long (beyond Integer.MAX_VALUE): " + resource);
        }
        response.setContentLength((int)length);
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContent(HttpServletResponse response, Resource resource) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            StreamUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (mappingLocation.exists()) {
                InputStream inputStream = null;
                try {
                    inputStream = mappingLocation.getInputStream();
                    MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
                    return mimetypesFileTypeMap;
                }
                catch (IOException ex) {
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return FileTypeMap.getDefaultFileTypeMap();
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null;
        }
    }
}

