/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.config.annotation;

import java.util.HashMap;
import javax.servlet.ServletContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.DefaultServletHttpRequestHandler;

public class DefaultServletHandlerConfigurer {
    private final ServletContext servletContext;
    @Nullable
    private DefaultServletHttpRequestHandler handler;

    public DefaultServletHandlerConfigurer(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext is required");
        this.servletContext = servletContext;
    }

    public void enable() {
        this.enable(null);
    }

    public void enable(@Nullable String defaultServletName) {
        this.handler = new DefaultServletHttpRequestHandler();
        if (defaultServletName != null) {
            this.handler.setDefaultServletName(defaultServletName);
        }
        this.handler.setServletContext(this.servletContext);
    }

    @Nullable
    protected AbstractHandlerMapping getHandlerMapping() {
        if (this.handler == null) {
            return null;
        }
        HashMap<String, DefaultServletHttpRequestHandler> urlMap = new HashMap<String, DefaultServletHttpRequestHandler>();
        urlMap.put("/**", this.handler);
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(Integer.MAX_VALUE);
        handlerMapping.setUrlMap(urlMap);
        return handlerMapping;
    }
}

