/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.ErrorHandlingServerResponse;
import org.springframework.web.servlet.function.ServerResponse;

final class AsyncServerResponse
extends ErrorHandlingServerResponse {
    static final boolean reactiveStreamsPresent = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)AsyncServerResponse.class.getClassLoader());
    private final CompletableFuture<ServerResponse> futureResponse;

    private AsyncServerResponse(CompletableFuture<ServerResponse> futureResponse) {
        this.futureResponse = futureResponse;
    }

    @Override
    public HttpStatus statusCode() {
        return this.delegate(ServerResponse::statusCode);
    }

    @Override
    public int rawStatusCode() {
        return this.delegate(ServerResponse::rawStatusCode);
    }

    @Override
    public HttpHeaders headers() {
        return this.delegate(ServerResponse::headers);
    }

    @Override
    public MultiValueMap<String, Cookie> cookies() {
        return this.delegate(ServerResponse::cookies);
    }

    private <R> R delegate(Function<ServerResponse, R> function) {
        ServerResponse response = this.futureResponse.getNow(null);
        if (response != null) {
            return function.apply(response);
        }
        throw new IllegalStateException("Future ServerResponse has not yet completed");
    }

    @Override
    @Nullable
    public ModelAndView writeTo(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) {
        SharedAsyncContextHttpServletRequest sharedRequest = new SharedAsyncContextHttpServletRequest(request);
        AsyncContext asyncContext = sharedRequest.startAsync((ServletRequest)request, (ServletResponse)response);
        this.futureResponse.whenComplete((futureResponse, futureThrowable) -> {
            try {
                if (futureResponse != null) {
                    ModelAndView mav = futureResponse.writeTo((HttpServletRequest)sharedRequest, response, context);
                    Assert.state((mav == null ? 1 : 0) != 0, (String)"Asynchronous, rendering ServerResponse implementations are not supported in WebMvc.fn. Please use WebFlux.fn instead.");
                } else if (futureThrowable != null) {
                    this.handleError((Throwable)futureThrowable, request, response, context);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.handleError(throwable, request, response, context);
                }
                catch (IOException | ServletException ex) {
                    this.logger.warn((Object)"Asynchronous execution resulted in exception", ex);
                }
            }
            finally {
                asyncContext.complete();
            }
        });
        return null;
    }

    public static ServerResponse create(Object o) {
        ReactiveAdapterRegistry registry;
        ReactiveAdapter publisherAdapter;
        Assert.notNull((Object)o, (String)"Argument to async must not be null");
        if (o instanceof CompletableFuture) {
            CompletableFuture futureResponse = (CompletableFuture)o;
            return new AsyncServerResponse(futureResponse);
        }
        if (reactiveStreamsPresent && (publisherAdapter = (registry = ReactiveAdapterRegistry.getSharedInstance()).getAdapter(o.getClass())) != null) {
            Publisher publisher = publisherAdapter.toPublisher(o);
            ReactiveAdapter futureAdapter = registry.getAdapter(CompletableFuture.class);
            if (futureAdapter != null) {
                CompletableFuture futureResponse = (CompletableFuture)futureAdapter.fromPublisher(publisher);
                return new AsyncServerResponse(futureResponse);
            }
        }
        throw new IllegalArgumentException("Asynchronous type not supported: " + o.getClass());
    }

    private static final class SharedAsyncContextHttpServletRequest
    extends HttpServletRequestWrapper {
        private final AsyncContext asyncContext;
        private final AtomicInteger startedContexts;

        public SharedAsyncContextHttpServletRequest(HttpServletRequest request) {
            super(request);
            this.asyncContext = request.startAsync();
            this.startedContexts = new AtomicInteger(0);
        }

        private SharedAsyncContextHttpServletRequest(HttpServletRequest request, AsyncContext asyncContext, AtomicInteger startedContexts) {
            super(request);
            this.asyncContext = asyncContext;
            this.startedContexts = startedContexts;
        }

        public AsyncContext startAsync() throws IllegalStateException {
            this.startedContexts.incrementAndGet();
            return new SharedAsyncContext(this.asyncContext, this, this.asyncContext.getResponse(), this.startedContexts);
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            this.startedContexts.incrementAndGet();
            SharedAsyncContextHttpServletRequest sharedRequest = servletRequest instanceof SharedAsyncContextHttpServletRequest ? (SharedAsyncContextHttpServletRequest)servletRequest : new SharedAsyncContextHttpServletRequest((HttpServletRequest)servletRequest, this.asyncContext, this.startedContexts);
            return new SharedAsyncContext(this.asyncContext, sharedRequest, servletResponse, this.startedContexts);
        }

        public AsyncContext getAsyncContext() {
            return new SharedAsyncContext(this.asyncContext, this, this.asyncContext.getResponse(), this.startedContexts);
        }

        private static final class SharedAsyncContext
        implements AsyncContext {
            private final AsyncContext delegate;
            private final AtomicInteger openContexts;
            private final ServletRequest request;
            private final ServletResponse response;

            public SharedAsyncContext(AsyncContext delegate, SharedAsyncContextHttpServletRequest request, ServletResponse response, AtomicInteger usageCount) {
                this.delegate = delegate;
                this.request = request;
                this.response = response;
                this.openContexts = usageCount;
            }

            public void complete() {
                if (this.openContexts.decrementAndGet() == 0) {
                    this.delegate.complete();
                }
            }

            public ServletRequest getRequest() {
                return this.request;
            }

            public ServletResponse getResponse() {
                return this.response;
            }

            public boolean hasOriginalRequestAndResponse() {
                return this.delegate.hasOriginalRequestAndResponse();
            }

            public void dispatch() {
                this.delegate.dispatch();
            }

            public void dispatch(String path) {
                this.delegate.dispatch(path);
            }

            public void dispatch(ServletContext context, String path) {
                this.delegate.dispatch(context, path);
            }

            public void start(Runnable run) {
                this.delegate.start(run);
            }

            public void addListener(AsyncListener listener) {
                this.delegate.addListener(listener);
            }

            public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
                this.delegate.addListener(listener, servletRequest, servletResponse);
            }

            public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
                return (T)this.delegate.createListener(clazz);
            }

            public void setTimeout(long timeout) {
                this.delegate.setTimeout(timeout);
            }

            public long getTimeout() {
                return this.delegate.getTimeout();
            }
        }
    }
}

