/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.web.socket.server.support.AbstractHandshakeHandler;

class HandshakeHandlerRuntimeHints
implements RuntimeHintsRegistrar {
    private static final boolean tomcatWsPresent;
    private static final boolean jettyWsPresent;
    private static final boolean undertowWsPresent;
    private static final boolean glassfishWsPresent;
    private static final boolean weblogicWsPresent;
    private static final boolean websphereWsPresent;

    HandshakeHandlerRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ReflectionHints reflectionHints = hints.reflection();
        if (tomcatWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy");
        } else if (jettyWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy");
        } else if (undertowWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.UndertowRequestUpgradeStrategy");
        } else if (glassfishWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.GlassFishRequestUpgradeStrategy");
        } else if (weblogicWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.WebLogicRequestUpgradeStrategy");
        } else if (websphereWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.WebSphereRequestUpgradeStrategy");
        }
    }

    private void registerType(ReflectionHints reflectionHints, String className) {
        reflectionHints.registerType(TypeReference.of((String)className), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS}));
    }

    static {
        ClassLoader classLoader = AbstractHandshakeHandler.class.getClassLoader();
        tomcatWsPresent = ClassUtils.isPresent((String)"org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", (ClassLoader)classLoader);
        jettyWsPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServerContainer", (ClassLoader)classLoader);
        undertowWsPresent = ClassUtils.isPresent((String)"io.undertow.websockets.jsr.ServerWebSocketContainer", (ClassLoader)classLoader);
        glassfishWsPresent = ClassUtils.isPresent((String)"org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler", (ClassLoader)classLoader);
        weblogicWsPresent = ClassUtils.isPresent((String)"weblogic.websocket.tyrus.TyrusServletWriter", (ClassLoader)classLoader);
        websphereWsPresent = ClassUtils.isPresent((String)"com.ibm.websphere.wsoc.WsWsocServerContainer", (ClassLoader)classLoader);
    }
}

