/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.caucho.CauchoRemoteAccessor;

public class BurlapClientInterceptor
extends CauchoRemoteAccessor
implements MethodInterceptor {
    private BurlapProxyFactory proxyFactory;
    private Object burlapProxy;

    public void setProxyFactory(BurlapProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void prepare() throws MalformedURLException {
        super.prepare();
        if (this.proxyFactory == null) {
            this.proxyFactory = new BurlapProxyFactory();
        }
        if (this.getUsername() != null) {
            this.proxyFactory.setUser(this.getUsername());
        }
        if (this.getPassword() != null) {
            this.proxyFactory.setPassword(this.getPassword());
        }
        if (this.isOverloadEnabled()) {
            this.proxyFactory.setOverloadEnabled(this.isOverloadEnabled());
        }
        this.burlapProxy = this.createBurlapProxy(this.proxyFactory);
    }

    protected Object createBurlapProxy(BurlapProxyFactory proxyFactory) throws MalformedURLException {
        return proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.burlapProxy == null) {
            throw new IllegalStateException("BurlapClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        try {
            return invocation.getMethod().invoke(this.burlapProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof BurlapRuntimeException) {
                BurlapRuntimeException bre = (BurlapRuntimeException)ex.getTargetException();
                Object rootCause = bre.getRootCause() != null ? bre.getRootCause() : bre;
                throw this.convertBurlapAccessException((Throwable)rootCause);
            }
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw this.convertBurlapAccessException(utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new AspectException("Failed to invoke Burlap service [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteAccessException convertBurlapAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Cannot connect to Burlap service at [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access Burlap service at [" + this.getServiceUrl() + "]", ex);
    }
}

