/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodInvoker {
    public static final VoidType VOID = new VoidType();
    private Class targetClass;
    private Object targetObject;
    private String targetMethod;
    private Object[] arguments;
    private Method methodObject;
    static /* synthetic */ Class class$java$lang$Object;

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
        if (targetObject != null) {
            this.targetClass = targetObject.getClass();
        }
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public String getTargetMethod() {
        return this.targetMethod;
    }

    public void setStaticMethod(String staticMethod) throws ClassNotFoundException {
        int lastDotIndex = staticMethod.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == staticMethod.length()) {
            throw new IllegalArgumentException("staticMethod must be a fully qualified class plus method name: e.g. 'example.MyExampleClass.myExampleMethod'");
        }
        String className = staticMethod.substring(0, lastDotIndex);
        String methodName = staticMethod.substring(lastDotIndex + 1);
        this.setTargetClass(Class.forName(className, true, Thread.currentThread().getContextClassLoader()));
        this.setTargetMethod(methodName);
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void prepare() throws ClassNotFoundException, NoSuchMethodException {
        block7: {
            if (this.targetClass == null) {
                throw new IllegalArgumentException("Either targetClass or targetObject is required");
            }
            if (this.targetMethod == null) {
                throw new IllegalArgumentException("targetMethod is required");
            }
            if (this.arguments == null) {
                this.arguments = new Object[0];
            }
            Class[] argTypes = new Class[this.arguments.length];
            for (int i = 0; i < this.arguments.length; ++i) {
                argTypes[i] = this.arguments[i] != null ? this.arguments[i].getClass() : (class$java$lang$Object == null ? MethodInvoker.class$("java.lang.Object") : class$java$lang$Object);
            }
            try {
                this.methodObject = this.targetClass.getMethod(this.targetMethod, argTypes);
            }
            catch (NoSuchMethodException ex) {
                this.methodObject = this.findMatchingMethod();
                if (this.methodObject != null) break block7;
                throw ex;
            }
        }
        if (this.targetObject == null && !Modifier.isStatic(this.methodObject.getModifiers())) {
            throw new IllegalArgumentException("Target method must not be non-static without a target");
        }
    }

    protected Method findMatchingMethod() {
        Method[] candidates = this.getTargetClass().getMethods();
        int argCount = this.getArguments().length;
        Method matchingMethod = null;
        int numberOfMatchingMethods = 0;
        for (int i = 0; i < candidates.length; ++i) {
            if (!candidates[i].getName().equals(this.getTargetMethod()) || candidates[i].getParameterTypes().length != argCount) continue;
            matchingMethod = candidates[i];
            ++numberOfMatchingMethods;
        }
        if (numberOfMatchingMethods == 1) {
            return matchingMethod;
        }
        return null;
    }

    public Method getPreparedMethod() {
        return this.methodObject;
    }

    public Object invoke() throws InvocationTargetException, IllegalAccessException {
        if (this.methodObject == null) {
            throw new IllegalStateException("prepare() must be called prior to invoke() on MethodInvoker");
        }
        return this.methodObject.invoke(this.targetObject, this.arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class VoidType {
    }
}

