/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ResponseTimeMonitorImpl;
import org.springframework.web.context.support.RequestHandledEvent;

public class PerformanceMonitorListener
implements ApplicationListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ResponseTimeMonitorImpl responseTimeMonitor = new ResponseTimeMonitorImpl();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof RequestHandledEvent) {
            RequestHandledEvent rhe = (RequestHandledEvent)event;
            this.responseTimeMonitor.recordResponseTime(rhe.getProcessingTimeMillis());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("PerformanceMonitorListener: last=[" + rhe.getProcessingTimeMillis() + "ms]; " + this.responseTimeMonitor + "; client=[" + rhe.getClientAddress() + "]"));
            }
        }
    }
}

