/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.StringUtils;

public class MutablePropertyValues
implements PropertyValues,
Serializable {
    private final ArrayList propertyValueList;

    public MutablePropertyValues() {
        this.propertyValueList = new ArrayList();
    }

    public MutablePropertyValues(PropertyValues source) {
        if (source != null) {
            PropertyValue[] pvs = source.getPropertyValues();
            this.propertyValueList = new ArrayList(pvs.length);
            for (int i = 0; i < pvs.length; ++i) {
                PropertyValue newPv = new PropertyValue(pvs[i].getName(), pvs[i].getValue());
                this.propertyValueList.add(newPv);
            }
        } else {
            this.propertyValueList = new ArrayList(0);
        }
    }

    public MutablePropertyValues(Map source) {
        if (source != null) {
            this.propertyValueList = new ArrayList(source.size());
            Iterator it = source.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PropertyValue newPv = new PropertyValue((String)entry.getKey(), entry.getValue());
                this.propertyValueList.add(newPv);
            }
        } else {
            this.propertyValueList = new ArrayList(0);
        }
    }

    public MutablePropertyValues addPropertyValues(PropertyValues source) {
        if (source != null) {
            PropertyValue[] pvs = source.getPropertyValues();
            for (int i = 0; i < pvs.length; ++i) {
                PropertyValue newPv = new PropertyValue(pvs[i].getName(), pvs[i].getValue());
                this.addPropertyValue(newPv);
            }
        }
        return this;
    }

    public MutablePropertyValues addPropertyValues(Map source) {
        if (source != null) {
            Iterator it = source.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PropertyValue newPv = new PropertyValue((String)entry.getKey(), entry.getValue());
                this.addPropertyValue(newPv);
            }
        }
        return this;
    }

    public MutablePropertyValues addPropertyValue(PropertyValue pv) {
        for (int i = 0; i < this.propertyValueList.size(); ++i) {
            PropertyValue currentPv = (PropertyValue)this.propertyValueList.get(i);
            if (!currentPv.getName().equals(pv.getName())) continue;
            this.setPropertyValueAt(pv, i);
            return this;
        }
        this.propertyValueList.add(pv);
        return this;
    }

    public void addPropertyValue(String propertyName, Object propertyValue) {
        this.addPropertyValue(new PropertyValue(propertyName, propertyValue));
    }

    public void removePropertyValue(PropertyValue pv) {
        this.propertyValueList.remove(pv);
    }

    public void removePropertyValue(String propertyName) {
        this.removePropertyValue(this.getPropertyValue(propertyName));
    }

    public void setPropertyValueAt(PropertyValue pv, int i) {
        this.propertyValueList.set(i, pv);
    }

    public PropertyValue[] getPropertyValues() {
        return this.propertyValueList.toArray(new PropertyValue[this.propertyValueList.size()]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        for (int i = 0; i < this.propertyValueList.size(); ++i) {
            PropertyValue pv = (PropertyValue)this.propertyValueList.get(i);
            if (!pv.getName().equals(propertyName)) continue;
            return pv;
        }
        return null;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        if (old == this) {
            return changes;
        }
        Iterator it = this.propertyValueList.iterator();
        while (it.hasNext()) {
            PropertyValue newPv = (PropertyValue)it.next();
            PropertyValue pvOld = old.getPropertyValue(newPv.getName());
            if (pvOld == null) {
                changes.addPropertyValue(newPv);
                continue;
            }
            if (pvOld.equals(newPv)) continue;
            changes.addPropertyValue(newPv);
        }
        return changes;
    }

    public String toString() {
        Object[] pvs = this.getPropertyValues();
        StringBuffer sb = new StringBuffer("PropertyValues: length=" + pvs.length + "; ");
        sb.append(StringUtils.arrayToDelimitedString(pvs, "; "));
        return sb.toString();
    }
}

