/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class InternalResourceView
extends AbstractUrlBasedView {
    public InternalResourceView() {
    }

    public InternalResourceView(String url) {
        this.setUrl(url);
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        this.exposeHelpers(request);
        String dispatcherPath = this.prepareForRendering(request, response);
        RequestDispatcher rd = request.getRequestDispatcher(dispatcherPath);
        if (rd == null) {
            throw new ServletException("Could not get RequestDispatcher for [" + this.getUrl() + "]: check that this file exists within your WAR");
        }
        if (this.useInclude(request, response)) {
            rd.include((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Included resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarded to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
        }
    }

    protected void exposeModelAsRequestAttributes(Map model, HttpServletRequest request) throws Exception {
        Iterator it = model.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new ServletException("Invalid key [" + entry.getKey() + "] in model Map - only Strings allowed as model keys");
            }
            String modelName = (String)entry.getKey();
            Object modelValue = entry.getValue();
            if (modelValue != null) {
                request.setAttribute(modelName, modelValue);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added model object '" + modelName + "' of type [" + modelValue.getClass().getName() + "] to request in InternalResourceView '" + this.getBeanName() + "'"));
                continue;
            }
            request.removeAttribute(modelName);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Removed model object '" + modelName + "' from request in InternalResourceView '" + this.getBeanName() + "'"));
        }
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
    }

    protected String prepareForRendering(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getUrl();
    }

    protected boolean useInclude(HttpServletRequest request, HttpServletResponse response) {
        return request.getAttribute("javax.servlet.include.request_uri") != null || response.isCommitted();
    }
}

