/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3.support;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.def.DefaultMergeEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class IdTransferringMergeEventListener
extends DefaultMergeEventListener {
    protected Object entityIsTransient(MergeEvent event, Map copyCache) {
        Object mergedCopy = super.entityIsTransient(event, copyCache);
        SessionImplementor session = event.getSession();
        EntityPersister persister = session.getEntityPersister(event.getEntityName(), event.getEntity());
        Serializable id = persister.getIdentifier(mergedCopy, session.getEntityMode());
        persister.setIdentifier(event.getOriginal(), id, session.getEntityMode());
        return mergedCopy;
    }
}

