/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.rmi.CodebaseAwareObjectInputStream;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedExporter;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class HttpInvokerServiceExporter
extends RemoteInvocationBasedExporter
implements Controller,
InitializingBean {
    protected static final String CONTENT_TYPE_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    private Object proxy;
    static /* synthetic */ Class class$org$springframework$remoting$support$RemoteInvocation;

    public void afterPropertiesSet() {
        this.proxy = this.getProxyForService();
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassNotFoundException {
        RemoteInvocation invocation = this.readRemoteInvocation(request);
        RemoteInvocationResult result = this.invokeAndCreateResult(invocation, this.proxy);
        this.writeRemoteInvocationResult(request, response, result);
        return null;
    }

    protected RemoteInvocation readRemoteInvocation(HttpServletRequest request) throws IOException, ClassNotFoundException {
        return this.readRemoteInvocation(request, (InputStream)request.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocation readRemoteInvocation(HttpServletRequest request, InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = this.createObjectInputStream(this.decorateInputStream(request, is));
        try {
            RemoteInvocation remoteInvocation = this.doReadRemoteInvocation(ois);
            return remoteInvocation;
        }
        finally {
            ois.close();
        }
    }

    protected InputStream decorateInputStream(HttpServletRequest request, InputStream is) throws IOException {
        return is;
    }

    protected ObjectInputStream createObjectInputStream(InputStream is) throws IOException {
        return new CodebaseAwareObjectInputStream(is, null);
    }

    protected RemoteInvocation doReadRemoteInvocation(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object obj = ois.readObject();
        if (!(obj instanceof RemoteInvocation)) {
            throw new IOException("Deserialized object needs to be assignable to type [" + (class$org$springframework$remoting$support$RemoteInvocation == null ? (class$org$springframework$remoting$support$RemoteInvocation = HttpInvokerServiceExporter.class$("org.springframework.remoting.support.RemoteInvocation")) : class$org$springframework$remoting$support$RemoteInvocation).getName() + "]: " + obj);
        }
        return (RemoteInvocation)obj;
    }

    protected void writeRemoteInvocationResult(HttpServletRequest request, HttpServletResponse response, RemoteInvocationResult result) throws IOException {
        response.setContentType(CONTENT_TYPE_SERIALIZED_OBJECT);
        this.writeRemoteInvocationResult(request, response, result, (OutputStream)response.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRemoteInvocationResult(HttpServletRequest request, HttpServletResponse response, RemoteInvocationResult result, OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(this.decorateOutputStream(request, response, os));
        try {
            this.doWriteRemoteInvocationResult(result, oos);
            oos.flush();
        }
        finally {
            oos.close();
        }
    }

    protected OutputStream decorateOutputStream(HttpServletRequest request, HttpServletResponse response, OutputStream os) throws IOException {
        return os;
    }

    protected void doWriteRemoteInvocationResult(RemoteInvocationResult result, ObjectOutputStream oos) throws IOException {
        oos.writeObject(result);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

