/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.boot.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.statemachine.boot.StateMachineProperties;
import org.springframework.statemachine.boot.actuate.InMemoryStateMachineTraceRepository;
import org.springframework.statemachine.boot.actuate.StateMachineTraceEndpoint;
import org.springframework.statemachine.boot.actuate.StateMachineTraceRepository;
import org.springframework.statemachine.boot.support.BootStateMachineMonitor;

@AutoConfiguration
@EnableConfigurationProperties(value={StateMachineProperties.class})
@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnProperty(prefix="spring.statemachine.monitor", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class StateMachineAutoConfiguration {

    @Configuration
    public static class StateMachineMonitoringConfiguration {
        private final MeterRegistry meterRegistry;
        private final StateMachineTraceRepository stateMachineTraceRepository;

        public StateMachineMonitoringConfiguration(ObjectProvider<MeterRegistry> meterRegistryProvider, ObjectProvider<StateMachineTraceRepository> traceRepositoryProvider) {
            this.meterRegistry = (MeterRegistry)meterRegistryProvider.getIfAvailable();
            this.stateMachineTraceRepository = (StateMachineTraceRepository)traceRepositoryProvider.getIfAvailable();
        }

        @Bean
        public BootStateMachineMonitor<?, ?> bootStateMachineMonitor() {
            return new BootStateMachineMonitor(this.meterRegistry, this.stateMachineTraceRepository);
        }
    }

    @Configuration
    public static class StateMachineTraceRepositoryConfiguration {
        @ConditionalOnMissingBean(value={StateMachineTraceRepository.class})
        @Bean
        public InMemoryStateMachineTraceRepository stateMachineTraceRepository() {
            return new InMemoryStateMachineTraceRepository();
        }
    }

    @ManagementContextConfiguration
    public static class StateMachineTraceEndpointConfiguration {
        @Bean
        public StateMachineTraceEndpoint stateMachineTraceEndpoint(StateMachineTraceRepository stateMachineTraceRepository) {
            return new StateMachineTraceEndpoint(stateMachineTraceRepository);
        }
    }
}

