/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.security;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.springframework.faces.security.FaceletsAuthorizeTag;
import org.springframework.security.core.context.SecurityContextHolder;

public class FaceletsAuthorizeTagHandler
extends TagHandler {
    private final TagAttribute access = this.getAttribute("access");
    private final TagAttribute url = this.getAttribute("url");
    private final TagAttribute method = this.getAttribute("method");
    private final TagAttribute ifAllGranted = this.getAttribute("ifAllGranted");
    private final TagAttribute ifAnyGranted = this.getAttribute("ifAnyGranted");
    private final TagAttribute ifNotGranted = this.getAttribute("ifNotGranted");
    private final TagAttribute var = this.getAttribute("var");

    public FaceletsAuthorizeTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException {
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            return;
        }
        FaceletsAuthorizeTag authorizeTag = new FaceletsAuthorizeTag(faceletContext, this.access, this.url, this.method, this.ifAllGranted, this.ifAnyGranted, this.ifNotGranted);
        boolean isAuthorized = authorizeTag.authorize();
        if (isAuthorized) {
            this.nextHandler.apply(faceletContext, parent);
        }
        if (this.var != null) {
            faceletContext.setAttribute(this.var.getValue(faceletContext), (Object)isAuthorized);
        }
    }
}

