/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.faces.webflow.FacesContextHelper;
import org.springframework.faces.webflow.FlowFacesContextLifecycleListener;
import org.springframework.faces.webflow.JsfAjaxHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.webflow.context.servlet.AjaxHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

public class JsfFlowHandlerAdapter
extends FlowHandlerAdapter {
    public void afterPropertiesSet() throws Exception {
        boolean isAjaxHandlerConfigured = this.getAjaxHandler() != null;
        super.afterPropertiesSet();
        if (!isAjaxHandlerConfigured) {
            JsfAjaxHandler handler = new JsfAjaxHandler();
            handler.setApplicationContext(this.getApplicationContext());
            this.setAjaxHandler((AjaxHandler)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        FacesContextHelper helper = new FacesContextHelper();
        try {
            FacesContext facesContext = helper.getFacesContext(this.getServletContext(), request, response);
            request.setAttribute(FlowFacesContextLifecycleListener.DEFAULT_FACES_CONTEXT, (Object)facesContext);
            ModelAndView modelAndView = super.handle(request, response, handler);
            return modelAndView;
        }
        finally {
            request.removeAttribute(FlowFacesContextLifecycleListener.DEFAULT_FACES_CONTEXT);
            helper.releaseIfNecessary();
        }
    }
}

