/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.test.jetty;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyFactory {
    private static final String DEFAULT_WEBAPP_PATH = "src/main/webapp";
    private static final String WINDOWS_WEBDEFAULT_PATH = "jetty/webdefault-windows.xml";

    public static Server createServerInSource(int port, String contextPath) {
        Server server = new Server();
        server.setStopAtShutdown(true);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        connector.setReuseAddress(false);
        server.setConnectors(new Connector[]{connector});
        WebAppContext webContext = new WebAppContext(DEFAULT_WEBAPP_PATH, contextPath);
        webContext.setDefaultsDescriptor(WINDOWS_WEBDEFAULT_PATH);
        server.setHandler((Handler)webContext);
        return server;
    }

    public static void setTldJarNames(Server server, String ... jarNames) {
        WebAppContext context = (WebAppContext)server.getHandler();
        ArrayList jarNameExprssions = Lists.newArrayList((Object[])new String[]{".*/jstl-[^/]*\\.jar$", ".*/.*taglibs[^/]*\\.jar$"});
        for (String jarName : jarNames) {
            jarNameExprssions.add(".*/" + jarName + "-[^/]*\\.jar$");
        }
        context.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)StringUtils.join((Iterable)jarNameExprssions, (char)'|'));
    }

    public static void reloadContext(Server server) throws Exception {
        WebAppContext context = (WebAppContext)server.getHandler();
        System.out.println("[INFO] Application reloading");
        context.stop();
        WebAppClassLoader classLoader = new WebAppClassLoader((WebAppClassLoader.Context)context);
        classLoader.addClassPath("target/classes");
        classLoader.addClassPath("target/test-classes");
        context.setClassLoader((ClassLoader)classLoader);
        context.start();
        System.out.println("[INFO] Application reloaded");
    }
}

