/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.test.log;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.LoggerFactory;

public class LogbackListAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final List<ILoggingEvent> logs = Lists.newArrayList();

    public LogbackListAppender() {
        this.start();
    }

    protected void append(ILoggingEvent e) {
        this.logs.add(e);
    }

    public ILoggingEvent getFirstLog() {
        if (this.logs.isEmpty()) {
            return null;
        }
        return this.logs.get(0);
    }

    public String getFirstMessage() {
        if (this.logs.isEmpty()) {
            return null;
        }
        return this.getFirstLog().getFormattedMessage();
    }

    public ILoggingEvent getLastLog() {
        if (this.logs.isEmpty()) {
            return null;
        }
        return (ILoggingEvent)Iterables.getLast(this.logs);
    }

    public String getLastMessage() {
        if (this.logs.isEmpty()) {
            return null;
        }
        return this.getLastLog().getFormattedMessage();
    }

    public List<ILoggingEvent> getAllLogs() {
        return this.logs;
    }

    public int getLogsCount() {
        return this.logs.size();
    }

    public boolean isEmpty() {
        return this.logs.isEmpty();
    }

    public void clearLogs() {
        this.logs.clear();
    }

    public void addToLogger(String loggerName) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)loggerName);
        logger.addAppender((Appender)this);
    }

    public void addToLogger(Class<?> loggerClass) {
        Logger logger = (Logger)LoggerFactory.getLogger(loggerClass);
        logger.addAppender((Appender)this);
    }

    public void addToRootLogger() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.addAppender((Appender)this);
    }

    public void removeFromLogger(String loggerName) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)loggerName);
        logger.detachAppender((Appender)this);
    }

    public void removeFromLogger(Class<?> loggerClass) {
        Logger logger = (Logger)LoggerFactory.getLogger(loggerClass);
        logger.detachAppender((Appender)this);
    }

    public void removeFromRootLogger() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.detachAppender((Appender)this);
    }
}

