/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.test.security.shiro;

import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.apache.shiro.util.ThreadState;
import org.mockito.Mockito;

public class ShiroTestUtils {
    private static ThreadState threadState;

    public static void mockSubject(Object principal) {
        Subject subject = (Subject)Mockito.mock(Subject.class);
        Mockito.when((Object)subject.isAuthenticated()).thenReturn((Object)true);
        Mockito.when((Object)subject.getPrincipal()).thenReturn(principal);
        ShiroTestUtils.bindSubject(subject);
    }

    protected static void bindSubject(Subject subject) {
        ShiroTestUtils.clearSubject();
        threadState = new SubjectThreadState(subject);
        threadState.bind();
    }

    public static void clearSubject() {
        if (threadState != null) {
            threadState.clear();
            threadState = null;
        }
    }
}

