/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.test.selenium;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverFactory {
    public static WebDriver createDriver(String driverName) {
        FirefoxDriver driver = null;
        if (BrowserType.firefox.name().equals(driverName)) {
            driver = new FirefoxDriver();
        } else if (BrowserType.ie.name().equals(driverName)) {
            driver = new InternetExplorerDriver();
        } else if (BrowserType.chrome.name().equals(driverName)) {
            driver = new ChromeDriver();
        } else if (driverName.startsWith(BrowserType.remote.name())) {
            String[] params = driverName.split(":");
            Validate.isTrue((params.length == 4 ? 1 : 0) != 0, (String)("Remote driver is not right, accept format is \"remote:localhost:4444:firefox\", but the input is\"" + driverName + "\""), (Object[])new Object[0]);
            String remoteHost = params[1];
            String remotePort = params[2];
            String driverType = params[3];
            String remoteUrl = "http://" + remoteHost + ":" + remotePort + "/wd/hub";
            DesiredCapabilities cap = null;
            if (BrowserType.firefox.name().equals(driverType)) {
                cap = DesiredCapabilities.firefox();
            } else if (BrowserType.ie.name().equals(driverType)) {
                cap = DesiredCapabilities.internetExplorer();
            } else if (BrowserType.chrome.name().equals(driverType)) {
                cap = DesiredCapabilities.chrome();
            }
            try {
                driver = new RemoteWebDriver(new URL(remoteUrl), (Capabilities)cap);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        Validate.notNull((Object)driver, (String)("Driver could be found by name:" + driverName), (Object[])new Object[0]);
        return driver;
    }

    public static enum BrowserType {
        firefox,
        ie,
        chrome,
        remote;

    }
}

