/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.test.benchmark;

import org.springside.modules.test.benchmark.ConcurrentBenchmark;

public abstract class BenchmarkTask
implements Runnable {
    protected int taskSequence;
    protected ConcurrentBenchmark parent;

    @Override
    public void run() {
        this.setUp();
        this.onThreadStart();
        try {
            int i = 1;
            while ((long)i <= this.parent.loopCount) {
                this.execute(i);
                this.parent.incCounter();
                ++i;
            }
        }
        finally {
            this.tearDown();
            this.onThreadFinish();
        }
    }

    protected abstract void execute(int var1);

    protected void onThreadStart() {
        this.parent.startLock.countDown();
        try {
            this.parent.startLock.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void onThreadFinish() {
        this.parent.finishLock.countDown();
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }
}

